C*****  CNDOTP  Complex Nested Dot Product        MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CNDOTP (A,IAI,IAO,B,IBI,IBO,C,ICO,M,N,IFLG)
C
C       where,
C
C       A       Complex input vector.
C
C       IAI     Integer input stride of dot product (inner loop) for A.
C
C       IAO     Integer input stride between successive
C               dot products (outer loop) for A.
C
C       B       Complex input vector.
C
C       IBI     Integer input stride of dot product (inner loop) for B.
C
C       IBO     Integer input stride between successive dot
C               products (outer loop) for B.
C
C       C       Complex input/output vector.
C
C       ICO     Integer input stride between successive dot
C               product outputs (outer loop) for C.
C
C       M       Integer input number of elements in each dot product,
C               the inner loop count.
C
C       N       Integer input number of dot products to be executed,
C               the outer loop count.
C
C       IFLG    Integer input processing option flag:
C                   Option 1 (=8) to conjugate A before dotting.
C                   Option 2 (=4) to conjugate B before dotting.
C                   Option 3 (=2) to add the dot product to the
C                                 input values of C.
C                   Option 4 (=1) to negate the result of dot product.
C                 The value of IFLG is additive, that is:
C                   IFLG = Option 1 + Option 2 + Option 3 + Option 4
C                 For example, if IFLG = 11 (i.e., 8+2+1), CNDOTP
C                 will conjugate A before computing the dot product,
C                 negate the dot product, and add the result to C.
C
C
C  DESCRIPTION
C
C       This routine performs a dot product using a portion of
C       vector A and a portion of vector B and stores the result
C       as an element of vector C.  It increments to the next
C       portion of A and B and repeats the operation, storing
C       the dot product in the next element of C. The operation
C       repeats N times.
C
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CNDOTP (A,4,2,B,2,6,C,2,3,2,2)
C
C       Input Operands:
C
C       A = ( 1.0, 2.0)    B = (1.0,-1.0)    C = (1.0,1.0)
C           ( 3.0, 4.0)        (2.0,-2.0)        (1.0,1.0)
C           ( 5.0, 6.0)        (3.0,-3.0)
C           ( 7.0, 8.0)        (4.0,-4.0)
C           ( 9.0,10.0)        (5.0,-5.0)
C           (11.0,12.0)        (6.0,-6.0)
C
C       Output Operands:
C
C       C = ( 83.0, 7.0)
C           (242.0,16.0)
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C
      SUBROUTINE CNDOTP(A,IAI,IAO,B,IBI,IBO,C,ICO,M,N,IFLG)
C
      INTEGER IAI,IAO,IBI,IBO,ICO,N,M,IFLG,I,J,JA,JB,JC,IA,IB,JSW
      REAL    A(1),B(1),C(1),SUMR1,SUMR2,SUMI1,SUMI2
      REAL    NEG,CJB,CJA
      INTEGER ACM
      IF (M.LE.0 .OR. N.LE.0 .OR. IFLG.LT.0 .OR. IFLG.GE.16) GOTO 800
C
C     THE INPUT SWITCH IFLG IS USED AS FOLLOWS:
C     BIT 0 SETS NEGATE, BIT 1 SETS ACCUMULATE
C     BIT 2 SETS CONJUGATE-B, BIT 3 SETS CONJUGATE-A
C
C     DEFAULT SWITCH VALUES:
      NEG = 1.0
      ACM = 0
      CJB = 1.0
      CJA = 1.0
C
      JSW = IFLG
      IF (JSW.LT.8) GOTO 10
        JSW = JSW - 8
        CJA = -1.0
10    CONTINUE
      IF (JSW.LT.4) GOTO 20
        JSW = JSW - 4
        CJB = -1.0
20    CONTINUE
      IF (JSW.LT.2) GOTO 30
        JSW = JSW - 2
        ACM = 1
30    CONTINUE
      IF (JSW.EQ.1) NEG = -1.0
C
      JA = 1
      JB = 1
      JC = 1
      DO 220 J = 1, N
         IA  = JA
         IB  = JB
         SUMR1 = 0.0
         SUMR2 = 0.0
         SUMI1 = 0.0
         SUMI2 = 0.0
         DO 210 I = 1, M
            SUMR1 = SUMR1 + A(IA) * B(IB)
            SUMR2 = SUMR2 + A(IA+1) * B(IB+1)
            SUMI1 = SUMI1 + A(IA) * B(IB+1)
            SUMI2 = SUMI2 + A(IA+1) * B(IB)
            IA  = IA + IAI
            IB  = IB + IBI
  210    CONTINUE
         IF (ACM.EQ.0) GOTO 214
           C(JC)   = C(JC) + NEG * (SUMR1 - CJA*CJB*SUMR2)
           C(JC+1) = C(JC+1) + NEG * (CJB*SUMI1 + CJA*SUMI2)
           GOTO 217
214      CONTINUE
           C(JC)   = NEG * (SUMR1 - CJA*CJB*SUMR2)
           C(JC+1) = NEG * (CJB*SUMI1 + CJA*SUMI2)
217      CONTINUE
         JA = JA + IAO
         JB = JB + IBO
         JC = JC + ICO
  220 CONTINUE
C
800   RETURN
      END
