C*****  CONV2D  2-D Convolution and Correlation     MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CONV2D (A,NRA,IRA,ICA,NRAA,NCAA,B,NRB,NCB,IIB,C,NRC,IRC,
C      +             ICC,IFLG)
C
C       where,
C
C       A       Real input matrix.
C
C       NRA     Integer input number of rows in full matrix A.
C
C       IRA     Integer input initial row of the submatrix of A.
C
C       ICA     Integer input initial column of the submatrix of A.
C
C       NRAA    Integer input number of rows in submatrix A.
C
C       NCAA    Integer input number of columns in submatrix A.
C
C       B       Real input matrix.
C
C       NRB     Integer input number of rows in matrix B.
C
C       NCB     Integer input number of columns in matrix B.
C
C       IIB     Integer input element number of B coinciding
C               with the element of A pointed to by IRA and ICA.
C
C       C       Real output matrix.
C
C       NRC     Integer input number of rows in full matrix C.
C
C       IRC     Integer input initial row of the submatrix of C.
C
C       ICC     Integer input initial column of the submatrix of C.
C
C       IFLG    Integer input processing option flag:
C                   =0 for convolution.
C                   =1 for correlation.
C
C
C  DESCRIPTION
C
C       This routine uses matrix B to perform a two-dimensional
C       convolution or correlation operation on submatrix AA of
C       full matrix A.
C
C       The formula for correlation is:
C
C            CC(i,j) = SUM[AA((i+k-1),(j+m-1))*B(k,m)]
C
C
C       The formula for convolution is:
C
C            CC(i,j) = SUM[AA((i+k-1),(j+m-1))*B(NRB-k+1,NCB-m+1)]
C
C       where,
C
C            i = 1,NRAA
C
C            j = 1,NCAA
C
C            k = 1,NRB
C
C            m = 1,NCB
C
C            AA and CC are the submatrices of A and C
C
C
C  REFERENCE
C
C       G. W. Jenkins and D. G. Watts.  1969.  Spectral
C       analysis and its applications.  San Francisco: Holden-
C       Day.
C
C
C  EXAMPLE
C
C       CALL CONV2D (A,8,1,1,6,6,B,3,3,1,C,8,1,1,1)
C
C       Input Operands:
C
C       A = 0.00  0.00  0.00  0.00  0.00  0.00  0.00  0.00
C           0.00  2.00  2.00  2.00  3.00  3.00  5.00  0.00
C           0.00  2.00  2.00  2.00  3.00  3.00  5.00  0.00
C           0.00  2.00  2.00  2.00  3.00  3.00  5.00  0.00
C           0.00  2.00  2.00  2.00  3.00  3.00  5.00  0.00
C           0.00  0.00  0.00  0.00  0.00  0.00  0.00  0.00
C           0.00  0.00  0.00  0.00  0.00  0.00  0.00  0.00
C           0.00  0.00  0.00  0.00  0.00  0.00  0.00  0.00
C
C       B = 0.00 -1.00  0.00
C         - 1.00  4.00 -1.00
C           0.00 -1.00  0.00
C
C
C       Output Operands:
C
C       C =  4.00  2.00  1.00  4.00  1.00 12.00  0.00  0.00
C            2.00  0.00 -1.00  1.00 -2.00  7.00  0.00  0.00
C            2.00  0.00 -1.00  1.00 -2.00  7.00  0.00  0.00
C            4.00  2.00  1.00  4.00  1.00  12.0  0.00  0.00
C           -2.00 -2.00 -2.00 -3.00 -3.00 -5.00  0.00  0.00
C            0.00  0.00  0.00  0.00  0.00  0.00  0.00  0.00
C            0.00  0.00  0.00  0.00  0.00  0.00  0.00  0.00
C            0.00  0.00  0.00  0.00  0.00  0.00  0.00  0.00
C
C  HISTORY
C         1) Apr 85     D. Cooper       Original.
C
      SUBROUTINE CONV2D(A,NRA,IRA,ICA,NRAA,NCAA,B,NRB,NCB,IIB,
     +  C,NRC,IRC,ICC,IFLG)
C
      REAL A(1), B(1), C(1)
      INTEGER NRA,IRA,ICA,NRAA,NCAA,NRB,NCB,IIB,NRC,IRC,ICC,IFLG
      INTEGER IB0,IRBIAS,ICBIAS,ROW,COL,STARTA,STARTC,KA,KC
      IF (NCAA.LE.0 .OR. NRAA.LE.0 .OR. NRAA.GT.NRA .OR.
     +    NRB.LE.0 .OR. NCB.LE.0 .OR.
     +    IRC.LE.0 .OR. IRC.GT.NRC .OR.
     +    ICC.LE.0 .OR. IIB.LE.0 .OR. IIB.GT.(NRB*NCB) .OR.
     +    ICA.LE.0 .OR. IRA.LE.0 .OR. IRA.GT.NRA .OR.
     +    IFLG.LT.0 .OR. IFLG.GT.1) GOTO 9000
C
C.... change IIB to IB0, a variable ranging from 0 to NRB*NCB-1 in
C     forward column order
      IB0 = IIB - 1
C      IF (IFLG.EQ.0) IB0 = NRB*NCB - IIB
C
C.....establish i, j bias.  this is just the number of cells to
C     back off the start of the count.
C     irbias is the i-direction
C     icbias is the j-direction
C
      ICBIAS = IB0/NRB
      IRBIAS = IB0 - (NRB*ICBIAS)
C
C.....get the i, j starting cell numbers
C        i-start = ia - irbias
C        j-start = ja - icbias
C ... and pre-decrement them before loop
C
      STARTA = (IRA - IRBIAS) + (NRA*((ICA-1) - ICBIAS)) - 1
      STARTC = IRC + (NRC*(ICC-1)) - 1
C
      DO 299 ROW = 1,NRAA
        KA = STARTA + ROW
        KC = STARTC + ROW
        DO 199 COL = 1,NCAA
          IF (IFLG.EQ.1) GOTO 50
C           CONVOLUTION:
            CALL QTC005(A(KA),NRA,B,NRB,C(KC),NCB)
          GOTO 100
C           CORRELATION:
50          CALL QTC006(A(KA),NRA,B,NRB,C(KC),NCB)
100       KA = KA + NRA
          KC = KC + NRC
199     CONTINUE
299   CONTINUE
9000  RETURN
      END
