C*****  CSCAL  Complex Scalar Times a Complex Vector        MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CSCAL (N,CA,CX,INCX)
C
C       where,
C
C       N       Integer input element count.
C
C       CA      Complex input scalar.
C
C       CX      Complex input vector.
C
C       INCX    Integer input stride for vector CX.
C               May not be negative.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of a complex vector CX
C       by a complex scalar CA.
C
C       CX(i) = CA * CX(i)               for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       CALL CSCAL (2,CA,CX,1)
C
C       Input Operands:
C
C       CA =  (1.000,2.000)
C
C       CX =  (1.000,-2.000)
C             (3.000, 4.000)
C
C       Output Operands:
C
C       CX = ( 5.000, 0.000)
C            (-5.000,10.000)
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      SUBROUTINE CSCAL(N,CA,CX,INCX)
C
      COMPLEX CA,CX(1)
      INTEGER N,INCX,NS,M
C
      IF (N.LE.0 .OR. INCX.LT.0) GO TO 40
      NS = N*INCX
      DO 10 M=1,NS,INCX
        CX(M) = CA*CX(M)
10    CONTINUE
40    RETURN
      END
