C*****  CTRN3   3-D Coordinate Transform          MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CTRN3 (A,B,IB,C,D,ID,N)
C
C       where,
C
C       A       Real input matrix, 3x3 rotation matrix.
C
C       B       Real input matrix, N sets of 3-element coordinate
C               vectors.
C
C       IB      Integer input stride between first elements
C               of each 3-element vector of B.
C
C       C       Real input vector, 3-element translation vector.
C
C       D       Real output matrix, N sets of 3-element vectors.
C
C       ID      Integer input stride between first elements of each
C               3-element vector of D.
C
C       N       Integer input number of 3-element vectors.
C
C
C  DESCRIPTION
C
C       This routine translates and rotates a series of 3-dimensional
C       coordinates and stores the results in matrix D.
C
C            D(i) = A * (B(i) - C)   for i=1,N
C
C       where,
C
C            D(i) and B(i) represent the particular set of coordinates.
C
C
C  REFERENCE
C
C       William M. Newman and Robert F. Sproull.  1979.  Prin-
C       ciples of interactive computer graphics.  New York:
C       McGraw-Hill.
C
C
C  EXAMPLE
C
C       CALL CTRN3 (A,B,3,C,D,3,2)
C
C       Input Operands:
C
C       A = 1.000   4.000   7.000
C           2.000   5.000   8.000
C           3.000   6.000   9.000
C
C       B = 6.000   3.000
C           5.000   2.000
C           4.000   1.000
C
C       C = 1.000
C           2.000
C           3.000
C
C       Output Operands:
C
C       D = 24.00   -12.00
C           33.00   -12.00
C           42.00   -12.00
C
C  HISTORY
C         1) May 85     D. Cooper       Original.
C
      SUBROUTINE CTRN3(A,B,IB,C,D,ID,N)
C
      INTEGER IB,ID,N,JJ,LL,M
      REAL A(1),B(1),C(1),D(1),D1,D2,D3
      IF (N.LE.0) GO TO 800
      JJ = 1
      LL = 1
      DO 120 M = 1, N
         D1 = A(1) * (B(JJ)-C(1)) + A(4) * (B(JJ+1)-C(2)) +
     +        A(7) * (B(JJ+2)-C(3))
         D2 = A(2) * (B(JJ)-C(1)) + A(5) * (B(JJ+1)-C(2)) +
     +        A(8) * (B(JJ+2)-C(3))
         D3 = A(3) * (B(JJ)-C(1)) + A(6) * (B(JJ+1)-C(2)) +
     +        A(9) * (B(JJ+2)-C(3))
         D(LL) = D1
         D(LL+1) = D2
         D(LL+2) = D3
         JJ = JJ + IB
         LL = LL + ID
120   CONTINUE
800   RETURN
      END
