C*****  CTRN4   4-D Coordinate Transform          MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CTRN4 (A,B,IB,C,D,ID,N)
C
C       where,
C
C       A       Real input matrix, 4x4 rotation matrix.
C
C       B       Real input matrix, N sets of 4-element coordinate
C               vectors.
C
C       IB      Integer input stride between first elements of each
C               4-element vector of B.
C
C       C       Real input vector, 4-element translation vector.
C
C       D       Real output matrix, N sets of 4-element vectors.
C
C       ID      Integer input stride between first elements of each
C               4-element vector of D.
C
C       N       Integer input number of 4-element vectors.
C
C
C  DESCRIPTION
C
C       This routine translates and rotates a series of 4-dimensional
C       coordinates and stores the results in matrix D.
C
C            D(i) = A * (B(i) - C)    for i=1,N
C
C       where,
C
C            D(i) and B(i) represent the particular set of coordinates
C
C
C  REFERENCE
C
C       William M. Newman and Robert F. Sproull.  1979.  Prin-
C       ciples of interactive computer graphics.  New York:
C       McGraw-Hill.
C
C
C  EXAMPLE
C
C       CALL CTRN4 (A,B,4,C,D,4,2)
C
C       Input Operands:
C
C       A = 1.000    5.000     9.000    13.000
C           2.000    6.000    10.000    14.000
C           3.000    7.000    11.000    15.000
C           4.000    8.000    12.000    16.000
C
C       B = 8.000    4.000
C           7.000    3.000
C           6.000    2.000
C           5.000    1.000
C
C       C = 1.000
C           2.000
C           3.000
C           4.000
C
C       Output Operands:
C
C       D =  72.000    -40.000
C            88.000    -40.000
C           104.000    -40.000
C           120.000    -40.000
C
C
C  HISTORY
C         1) May 85     D. Cooper       Original.
C
C
      SUBROUTINE CTRN4(A,B,IB,C,D,ID,N)
      INTEGER IB,ID,N,JJ,LL,M
      REAL A(1),B(1),C(1),D(1),D1,D2,D3,D4
      IF (N.LE.0) GO TO 800
      JJ = 1
      LL = 1
      DO 120 M = 1, N
         D1 = A(1) * (B(JJ)-C(1)) + A(5) * (B(JJ+1)-C(2)) +
     +        A(9) * (B(JJ+2)-C(3)) + A(13) * (B(JJ+3)-C(4))
         D2 = A(2) * (B(JJ)-C(1)) + A(6) * (B(JJ+1)-C(2)) +
     +        A(10) * (B(JJ+2)-C(3)) + A(14) * (B(JJ+3)-C(4))
         D3 = A(3) * (B(JJ)-C(1)) + A(7) * (B(JJ+1)-C(2)) +
     +        A(11) * (B(JJ+2)-C(3)) + A(15) * (B(JJ+3)-C(4))
         D4 = A(4) * (B(JJ)-C(1)) + A(8) * (B(JJ+1)-C(2)) +
     +        A(12) * (B(JJ+2)-C(3)) + A(16) * (B(JJ+3)-C(4))
         D(LL) = D1
         D(LL+1) = D2
         D(LL+2) = D3
         D(LL+3) = D4
         JJ = JJ + IB
         LL = LL + ID
120   CONTINUE
800   RETURN
      END
