C*****  CVMGSA  Complex Vector Magnitude Square and Add  MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CVMGSA (A,IA,B,IB,C,IC,N)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine computes the squared magnitude of each
C       element of a complex vector A, and adds it to a real vector
C       B, storing the results in real vector C.
C
C            C(i) = real(A(i))**2 + imag(A(i))**2 + B(i)    for i=1,N
C
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CVMGSA (A,2,B,1,C,1,3)
C
C       Input Operands:
C
C       A = ( 1.000,2.000)
C           ( 3.000,4.000)
C           (-1.000,1.000)
C
C       B = 10.000
C           15.000
C           20.000
C
C
C       Output Operands:
C
C       C = 15.000
C           40.000
C           22.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CVMGSA(A,IA,B,IB,C,IC,N)
C
      INTEGER IA,IB,IC,N,II,JJ,KK,M
      REAL A(1),B(1),C(1)
      IF (N.LE.0) GO TO 40
      II = 1
      JJ = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = B(JJ) + A(II)*A(II) + A(II+1)*A(II+1)
        II = II+IA
        JJ = JJ+IB
        KK = KK+IC
10    CONTINUE
40    RETURN
      END
