C*****  CVPHAS   Complex Vector Phase           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CVPHAS (A,IA,C,IC,N)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine computes the phase (in radians) of
C       the elements of complex input vector A.  The
C       results are stored in real vector C.
C
C         C(i) = ATAN2(imag(A(i)), real(A(i)))   for i = 1,N
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CVPHAS (A,2,C,1,3)
C
C       Input Operands:
C
C       A =  (1.000,2.000)
C            (3.000,4.000)
C            (5.000,6.000)
C
C       Output Operands:
C
C       C =  1.107
C            0.927
C            0.876
C
C  HISTORY
C         1) Jul 86     D. Benua         Original.
C
      SUBROUTINE CVPHAS(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),C(1)
      IF (N.LE.0) GO TO 40
      II = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = ATAN2( A(II+1), A(II) )
        II = II + IA
        KK = KK + IC
10    CONTINUE
40    RETURN
      END
