C*****  CVSMCO  Complex Vector Scalar Mult, Conj.Out MTHADV EXT. REL 1.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CVSMCO (A,IA,B,C,IC,N)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input scalar.
C
C       C       Complex output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine multiplies both the real and imaginary parts of
C       the elements of a complex vector by a real scalar B and stores
C       the the conjugate of the product in vector C.
C
C            real(C(i)) = real(A(i)) * B
C            imag(C(i)) = -imag(A(i)) * B    for i=1,N
C
C       This routine is functionally identical to Math Advantage
C       routine CVSMUL, except that the results have been conjugated.
C
C  Programming Note:
C
C        The use of an output vector stride of 0 causes a floating point
C        exception on the CRAY unless vectorization is disabled for the
C        DO 10 loop.
C
C
C
C  EXAMPLE
C
C       CALL CVSMCO (A,2,B,C,2,2)
C
C       Input Operands:
C
C       A =  (1.000,2.000)
C            (3.000,4.000)
C
C       B =  -2.000
C
C       Output Operands:
C
C       C = (-2.000, 4.000)
C           (-6.000, 8.000)
C
C  HISTORY
C         1) Oct 86     L.Tarvestad     Original.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE CVSMCO(A,IA,B,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),B,C(1)
C
C-----------------------------------------------------------------------
C
      IF (N.LE.0) GO TO 40
      II = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = B*A(II)
        C(KK+1) = -B*A(II+1)
        II = II+IA
        KK = KK+IC
10    CONTINUE
40    RETURN
      END
