C*****  DAXPY  Dbl Prec Scalar Times a Vector Plus a Vector  MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL DAXPY (N,DA,DX,INCX,DY,INCY)
C
C       where,
C
C       N       Integer input element count.
C
C       DA      Double precision real input scalar.
C
C       DX      Double precision real input vector.
C
C       INCX    Integer input stride for vector DX.
C
C       DY      Double precision real input/output vector.
C
C       INCY    Integer input stride for vector DY.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of a double precision
C       real vector DX by a double precision real scalar DA and adds
C       the elements of another double precision real vector DY.
C       The results are stored back in vector DY.
C
C       DY(i) = (DA * DX(i)) + DY(i)      for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       CALL DAXPY (2,DA,DX,1,DY,1)
C
C       Input Operands:
C
C       DA =  2.000
C
C       DX =  1.000
C             3.000
C
C       DY =  10.000
C             30.000
C
C       Output Operands:
C
C       DY =  12.000
C             36.000
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      SUBROUTINE DAXPY(N,DA,DX,INCX,DY,INCY)
C
      DOUBLE PRECISION DA,DX(1),DY(1)
      INTEGER N,INCX,INCY,II,KK,M
      IF (N.LE.0 .OR. DA.EQ.0.0D0) GO TO 40
      II = 1
      KK = 1
      IF (INCX.LT.0) II = (-N+1)*INCX + 1
      IF (INCY.LT.0) KK = (-N+1)*INCY + 1
      DO 10 M=1,N
        DY(KK) = DA*DX(II) + DY(KK)
        II = II+INCX
        KK = KK+INCY
10    CONTINUE
40    RETURN
      END
