C*****  DDOT    Dot Product of Double Precision Reals      MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       DW = DDOT (N,DX,INCX,DY,INCY)
C
C       where,
C
C       N       Integer input element count.
C
C       DX      Double precision real input vector.
C
C       INCX    Integer input stride for vector DX.
C
C       DY      Double precision real input vector.
C
C       INCY    Integer input stride for vector DY.
C
C
C  DESCRIPTION
C
C       This function returns the double precision dot product of the
C       elements of vector DX with the elements of vector DY.
C
C               DDOT = sum (DX(i)*DY(i))      for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       DW = DDOT (5,DX,1,DY,1)
C
C       Input Operands:
C
C       DX =  1.000
C             2.000
C             3.000
C             4.000
C             5.000
C
C       DY = -2.000
C            -1.000
C             0.000
C             1.000
C             2.000
C
C       Output Result:
C
C       DW = 10.0
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      DOUBLE PRECISION FUNCTION DDOT(N,DX,INCX,DY,INCY)
C
      DOUBLE PRECISION DX(1),DY(1)
      INTEGER N,INCX,INCY,II,KK,M
C
      DDOT = 0.0D0
      IF (N.LE.0) GO TO 40
      II = 1
      KK = 1
      IF (INCX.LT.0) II = (1-N)*INCX + 1
      IF (INCY.LT.0) KK = (1-N)*INCY + 1
      DO 10 M=1,N
        DDOT = DDOT + DX(II)*DY(KK)
        II = II + INCX
        KK = KK + INCY
10    CONTINUE
40    RETURN
      END
