C*****  FNRM2  Euclidian Norm Function, with Scaling MTHADV EXT. REL 1.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       Y = FNRM2 (N,X,INCX)
C
C       where,
C
C       Y       Real output function value.
C
C       N       Integer input element count.
C
C       X       Real input vector.
C
C       INCX    Integer input stride for vector X.
C
C
C  DESCRIPTION
C
C    This real function computes the Euclidean norm of vector X.
C    Scaling is used to avoid overflow and destructive underflow.
C
C    Y = SQRT( X(1)**2 + X(2)**2 + ... X(n)**2 )
C
C    In order to avoid destructive underflow and overflow, a 4-phase
C    method is used:  Scan for zero components with 1st phase.  Move
C    to 2nd phase when a component is nonzero and less than or equal to
C    CUTLO.  Move to 3rd phase when a component is greater than CUTLO
C    Move to 4th phase when a component is greater than or equal to
C    CUTHI/N.
C
C    This method requires definition of the following machine-dependent
C    constants.  The values DATA'd in this source are believed to be
C    acceptable for all machines.  Consult LINPAK SNRM2 documentation
C    for more details.
C
C    CUTLO = SQRT(U/EPS)  where EPS = smallest value where 1.0+EPS>1.0
C    CUTHI = SQRT(V)            U   = smallest representable pos. value
C                                  V   = largest representable value
C
C
C  EXAMPLE
C
C       Y = FNRM2 (4,X,1)
C
C       Input Operands:
C
C       X = 1.0
C           2.0
C           3.0
C           4.0
C
C       Output Operands:
C
C       Y = 5.48
C
C
C  HISTORY
C         1) Dec 86     L. Tarvestad    Original (LINPAK SNRM2).
C                                       Allow INCX<0.
C
C-----------------------------------------------------------------------
C
      REAL FUNCTION FNRM2(N,X,INCX)
C
      INTEGER N,INCX,NEXT,NN,I,J
      REAL X(1),CUTLO,CUTHI,HITEST,SUM,XMAX,ZERO,ONE
C
      DATA ZERO,ONE /0.0E0, 1.0E0/
      DATA CUTLO,CUTHI /4.441E-16, 1.304E19/
C
C-----------------------------------------------------------------------
C
      IF (N.GT.0) GO TO 10
        FNRM2 = ZERO
        GO TO 300
10    ASSIGN 30 TO NEXT
      SUM = ZERO
      NN = 1+(N-1)*INCX
C
C BEGIN MAIN LOOP
      I = 1
20    GO TO NEXT, (30,50,70,110)
30    IF (ABS(X(I)) .GT. CUTLO) GO TO 85
      ASSIGN 50 TO NEXT
      XMAX = ZERO
C
C PHASE 1.  SUM IS ZERO.
50    IF (X(I) .EQ. ZERO) GO TO 200
      IF (ABS(X(I)) .GT. CUTLO) GO TO 85
C
C PREPARE FOR PHASE 2.
      ASSIGN 70 TO NEXT
      GO TO 105
C
C PREPARE FOR PHASE 4.
100   I = J
      ASSIGN 110 TO NEXT
      SUM = (SUM/X(I)) / X(I)
105   XMAX = ABS(X(I))
      GO TO 115
C
C PHASE 2.  SUM IS SMALL; SCALE TO AVOID DESTRUCTIVE UNDERFLOW.
70    IF (ABS(X(I)) .GT. CUTLO) GO TO 75
C
C COMMON CODE FOR PHASES 2,4.  IN PHASE 4 SUM IS LARGE; SCALE TO AVOID O
110   IF (ABS(X(I)) .LE. XMAX) GO TO 115
        SUM = ONE + SUM*(XMAX/X(I))**2
        XMAX = ABS(X(I))
        GO TO 200
C
115   SUM = SUM + (X(I)/XMAX)**2
      GO TO 200
C
C PREPARE FOR PHASE 3.
75    SUM = (SUM*XMAX)*XMAX
C
C SET HITEST=CUTHI/N
85    HITEST = CUTHI/FLOAT(N)
C
C PHASE 3.  SUM IS MID-RANGE; NO SCALING.
      DO 95 J = I,NN,INCX
        IF (ABS(X(J)) .GE. HITEST) GO TO 100
        SUM = SUM + X(J)**2
95    CONTINUE
      FNRM2 = SQRT(SUM)
      GO TO 300
C
200   IF (I .EQ. NN) GO TO 290
      I = I+INCX
      GO TO 20
C
C END OF MAIN LOOP.  COMPUTE SQRT AND ADJUST FOR SCALING.
290   FNRM2 = XMAX*SQRT(SUM)
300   RETURN
      END
