C*****  ISAMAX    Index of Real Maximum Absolute Value   MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       IMAX = ISAMAX (N,SX,INCX)
C
C       where,
C
C       N       Integer input element count.
C
C       SX      Real input vector.
C
C       INCX    Integer input stride for vector SX.
C               Must be positive.
C
C
C  DESCRIPTION
C
C       This function returns the first index of the largest absolute
C       value of the elements in vector SX.
C
C               ISAMAX = i
C       where SX(i) = maximum(abs(SX(j)))     for j=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       IMAX = ISAMAX (4,SX,1)
C
C       Input Operands:
C
C       SX =  1.000
C             7.000
C             3.000
C             5.000
C
C       Output Result:
C
C       IMAX = 2
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      INTEGER FUNCTION ISAMAX(N,SX,INCX)
C
      REAL SX(1),SMAX,ABSVAL
      INTEGER N,INCX,II,M
C
      ISAMAX = 0
      IF (N.LE.0 .OR. INCX.LE.0) GO TO 40
      ISAMAX = 1
      IF (N.EQ.1) GO TO 40
      II = 1
      SMAX = ABS(SX(II))
      DO 10 M=2,N
        II = II + INCX
        ABSVAL = ABS(SX(II))
        IF (ABSVAL.LE.SMAX) GO TO 10
        ISAMAX = M
        SMAX = ABSVAL
10    CONTINUE
40    RETURN
      END
