C*****  LVNOT   Logical Vector Not                MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL LVNOT (A,IA,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine takes the logical complement of real input
C       vector A and stores the result in real output vector C.
C
C            C(i) = 1.0, if A(i) = 0.0,
C                 = 0.0, if A(i) <> 0.0,    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL LVNOT (A,1,C,1,5)
C
C       Input Operands:
C
C       A = 1.000
C           2.000
C           0.000
C           4.000
C           0.000
C
C       Output Operands:
C
C       C = 0.000
C           0.000
C           1.000
C           0.000
C           1.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE LVNOT(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),C(1)
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      DO 10 M=1,N
        IF (A(II).NE.0.0) GOTO 6
          C(KK) = 1.0
        GOTO 8
6         C(KK) = 0.0
8       II = II+IA
        KK = KK+IC
10    CONTINUE
12    RETURN
      END
