C*****  MORMD   Matrix Reorder, Minimum Degree    MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1988 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL MORMD (II,JJ,NV,N,IWRK,NIW,IPERMF,IPERMR,IERR)
C
C       where,
C
C       II      Integer input vector of length NV containing the row
C               indices of the nonzero elements of the matrix A.
C
C       JJ      Integer input vector of length NV containing the column
C               indices of the nonzero elements of the matrix A
C               corresponding to the elements of II.
C
C       NV      Integer input element count for II and JJ.
C
C       N       Integer input order of the matrix A.
C
C       IWRK    Integer scratch vector of length NIW.
C
C       NIW     Integer input element count for IWRK.
C
C       IPERMF  Integer output vector of length N containing the
C               forward permutation.
C
C       IPERMR  Integer output vector of length N containing the
C               reverse permutation.
C
C       IERR    Integer output scalar completion code:
C                  IERR = 0, normal completion
C                  IERR = 1, invalid value of NV or N
C                  IERR = 2, invalid index in II or JJ (<1 or >N)
C                  IERR = 3, IWRK is too small
C
C
C  DESCRIPTION
C
C       This routine finds a minimum degree reordering of a matrix A
C       to minimize the fill-in when the matrix is factored.
C       A reordering of a matrix is a renumbering of both the rows and
C       columns (equations and variables) such that if row i is
C       renumbered row j, then column i is also renumbered column j.
C
C       The ordering is given by the forward and reverse permutation
C       vectors, IPERMF and IPERMR.  The input vectors II and JJ are not
C       altered by this routine.  The value of IPERMF(I) is the
C       reordered index that the original index I is mapped to by the
C       reordering.  The value of IPERMR(I) is the original index from
C       which the reordered index I was mapped by the reordering.  Note
C       that IPERMF(IPERMR(I)) = I and IPERMR(IPERMF(I)) = I for all I.
C
C       For the purposes of reordering, the matrix A is assumed to have
C       a symmetric nonzero structure.  Thus, if A(i,j) is specified to
C       be nonzero, then A(j,i) will be treated as though it is also
C       nonzero.
C
C       Diagonal and redundant elements are ignored by the routine.  If
C       II(m) = II(k) and JJ(m) = JJ(k) or II(m) = JJ(k) and JJ(m) =
C       II(k) for some k and m such that 1 <= k < m <= NV, then the
C       element (II(m),JJ(m)) is redundant.  Thus, only the indices
C       of the non-diagonal nonzero elements need to be included in II
C       and JJ.  Furthermore, if the matrix is symmetric, then only the
C       indices of the nonzero elements above (or below) the diagonal
C       need to be input.
C
C       The minimum space required for the work vector IWRK is
C       7*N + 2*NE + 2.  Where NE is the number of non-diagonal,
C       non-redundant elements specified by II and JJ.  Alternately,
C       NE is the number of nonzero elements above (or below) the diagonal
C       in the matrix C = B + B' where B(i,j) = Abs[ A(i,j) ] and B' is
C       the transpose of B.  Note that NE will always be less than
C       or equal to NV.
C
C
C  REFERENCE
C
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems.  Englewood Cliffs, N.J.:
C       Prentice-Hall, Inc.
C
C
C  EXAMPLE
C
C       CALL MORMD (II,JJ,NV,N,IWRK,NIW,IPERMF,IPERMR,IERR)
C
C       Input Operands:
C
C       NV   =  21
C       N    =  10
C       NIW  = 140
C
C       II =  1      JJ =  1
C             2            1
C             5            1
C             9            1
C             2            2
C             3            2
C             6            2
C            10            2
C             3            3
C             4            4
C             7            4
C             8            4
C             9            4
C             5            5
C             8            5
C             6            6
C             7            7
C             8            8
C             9            8
C             9            9
C            10           10
C
C       Output Operands:
C
C       IERR = 0
C
C       IPERMF =  7    IPERMR =  3
C                 5              6
C                 1              7
C                 9             10
C                 6              2
C                 2              5
C                 3              1
C                10              9
C                 8              4
C                 4              8
C
C  HISTORY
C         1) Jan 88     R.D. Coleman    Original.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE MORMD (II, JJ, NV, N, IWRK, NIW, IPERMF, IPERMR, IERR)
C
C  PARAMETERS:
C
      INTEGER II(1), JJ(1), NV, N, IWRK(1), NIW, IPERMF(1), IPERMR(1),
     &        IERR
C
C  LOCAL VARIABLES:
C
      INTEGER IAD, IW1, IW2, IW3, IW4, IW5, IW6, JAD, LAST, MAX, NE, NE2
C
C-----------------------------------------------------------------------
C
      IERR = 0
      IF (N .LE. 0 .OR. NV .LE. 0) THEN
         IERR = 1
         GO TO 800
      ENDIF
C
      IW1 = 1
      IAD = IW1 + N
      JAD = IAD + N + 1
      MAX = NIW - JAD + 1
C
      IF (MAX .LE. 0) THEN
         IERR = 3
         GO TO 800
      ENDIF
C
C  BUILD ADJACENCY STRUCTURE
C
      CALL QTC060 (II, JJ, IWRK(IAD), IWRK(JAD), IWRK(IW1),
     &             NV, N, NE, MAX, IERR)
C
      IF (IERR .NE. 0) THEN
         IERR = IERR + 1
         GO TO 800
      ENDIF
C
C  FIND REORDERING
C
      NE2 = NE + NE
      IW2 = JAD + NE2
      IW3 = IW2 + N + 1
      IW4 = IW3 + N
      IW5 = IW4 + N
      IW6 = IW5 + N
C
      LAST = IW6 + N - 1
      IF (LAST .GT. NIW) THEN
         IERR = 3
         GO TO 800
      ENDIF
C
      CALL QTC071 (N, IWRK(IAD), IWRK(JAD), IPERMR, IPERMF,
     &             IWRK(IW1), IWRK(IW2), IWRK(IW3), IWRK(IW4),
     &             IWRK(IW5), IWRK(IW6))
C
  800 CONTINUE
      RETURN
      END
