C***** NCFFT     N ROUTINE FOR COMPLEX FFT'S    MTHADV EXT    REL 1.0
C
C   ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT:
C
C       CALL NCFFT( N, MRAD, M, IPWR )
C
C       where
C
C       N       Integer input number to be evaluated.
C
C       MRAD    Integer input value for the maximum radix to be used.
C
C       M       Integer output value for the smallest legal value.
C
C       IPWR    Integer output vector of length four that has the
C               exponents of 2, 3, 5, and 7 for the number M.
C
C   DESCRIPTION:
C       This routine is given the input integer N and returns the integer
C       M such that M is the smallest number greater than or equal to
C       N such that M = 2**I * 3**J * 5**K * 7**L where I, J, K, and L
C       are non-negative integers. J, K and L will be forced to zero
C       if the value of MRAD is less than 3. K and L will be forced to
C       zero if the value of MRAD is less than 5. L will be forced to zero
C       if the value of MRAD is less than 7. If MRAD is less than 2, a
C       value of 2 will be used.
C
C       The output vector IPWR contains the four exponents to form the
C       number M from powers of 2, 3, 5 and 7 respectively.
C
C       Data tables are used to optimize the execution time for numbers
C       less than or equal to 8192. If the input number is gerater than
C       8192, then an iterative loop is performed to factor out the powers
C       to determine the smallest valid number for M. This iterative method
C       is quite slow.
C
C
C  REFERENCES:
C
C       NONE
C
C  EXAMPLE:
C
C       CALL NCFFT( N, MRAD, M, IPWR )
C
C       INPUT OPERANDS:
C
C       N    =     1025
C
C       MRAD =     7
C
C       OUTPUT OPERANDS:
C
C       M    =     1029
C
C       IPWR =     0
C                  1
C                  0
C                  3
C
C  SUBPROGRAMS:
C
C       NONE
C
C  HISTORY:
C
C       1) June 1988              P.G. Crose               Original
C
C  ERROR CONDITIONS:
C       NONE.
C
C---------------------------------------------------------------------
C
      SUBROUTINE NCFFT (N, MRAD, M, IPWR)
C
      INTEGER N, MRAD, M, IPWR(4)
C
      INTEGER MAX
C
      PARAMETER (MAX = 316)
C
      INTEGER NUM(MAX), IN2(MAX), IN3(MAX), IN5(MAX), IN7(MAX)
      INTEGER N2, N3, N5, N7, ITMP, ITEST, I, I1, I2
C
C
      DATA (NUM(I), I = 1, 190) /
     &        2,    3,    4,    5,    6,    7,    8,    9,   10,   12,
     &       14,   15,   16,   18,   20,   21,   24,   25,   27,   28,
     &       30,   32,   35,   36,   40,   42,   45,   48,   49,   50,
     &       54,   56,   60,   63,   64,   70,   72,   75,   80,   81,
     &       84,   90,   96,   98,  100,  105,  108,  112,  120,  125,
     &      126,  128,  135,  140,  144,  147,  150,  160,  162,  168,
     &      175,  180,  189,  192,  196,  200,  210,  216,  224,  225,
     &      240,  243,  245,  250,  252,  256,  270,  280,  288,  294,
     &      300,  315,  320,  324,  336,  343,  350,  360,  375,  378,
     &      384,  392,  400,  405,  420,  432,  441,  448,  450,  480,
     &      486,  490,  500,  504,  512,  525,  540,  560,  567,  576,
     &      588,  600,  625,  630,  640,  648,  672,  675,  686,  700,
     &      720,  729,  735,  750,  756,  768,  784,  800,  810,  840,
     &      864,  875,  882,  896,  900,  945,  960,  972,  980, 1000,
     &     1008, 1024, 1029, 1050, 1080, 1120, 1125, 1134, 1152, 1176,
     &     1200, 1215, 1225, 1250, 1260, 1280, 1296, 1323, 1344, 1350,
     &     1372, 1400, 1440, 1458, 1470, 1500, 1512, 1536, 1568, 1575,
     &     1600, 1620, 1680, 1701, 1715, 1728, 1750, 1764, 1792, 1800,
     &     1875, 1890, 1920, 1944, 1960, 2000, 2016, 2025, 2048, 2058/
      DATA (NUM(I), I = 191, 316) /
     &     2100, 2160, 2187, 2205, 2240, 2250, 2268, 2304, 2352, 2400,
     &     2401, 2430, 2450, 2500, 2520, 2560, 2592, 2625, 2646, 2688,
     &     2700, 2744, 2800, 2835, 2880, 2916, 2940, 3000, 3024, 3072,
     &     3087, 3125, 3136, 3150, 3200, 3240, 3360, 3375, 3402, 3430,
     &     3456, 3500, 3528, 3584, 3600, 3645, 3675, 3750, 3780, 3840,
     &     3888, 3920, 3969, 4000, 4032, 4050, 4096, 4116, 4200, 4320,
     &     4374, 4375, 4410, 4480, 4500, 4536, 4608, 4704, 4725, 4800,
     &     4802, 4860, 4900, 5000, 5040, 5103, 5120, 5145, 5184, 5250,
     &     5292, 5376, 5400, 5488, 5600, 5625, 5670, 5760, 5832, 5880,
     &     6000, 6048, 6075, 6125, 6144, 6174, 6250, 6272, 6300, 6400,
     &     6480, 6561, 6615, 6720, 6750, 6804, 6860, 6912, 7000, 7056,
     &     7168, 7200, 7203, 7290, 7350, 7500, 7560, 7680, 7776, 7840,
     &     7875, 7938, 8000, 8064, 8100, 8192/
C
C
       DATA (IN2(I), I = 1, 190) /
     &     1,    0,    2,    0,    1,    0,    3,    0,    1,    2,
     &     1,    0,    4,    1,    2,    0,    3,    0,    0,    2,
     &     1,    5,    0,    2,    3,    1,    0,    4,    0,    1,
     &     1,    3,    2,    0,    6,    1,    3,    0,    4,    0,
     &     2,    1,    5,    1,    2,    0,    2,    4,    3,    0,
     &     1,    7,    0,    2,    4,    0,    1,    5,    1,    3,
     &     0,    2,    0,    6,    2,    3,    1,    3,    5,    0,
     &     4,    0,    0,    1,    2,    8,    1,    3,    5,    1,
     &     2,    0,    6,    2,    4,    0,    1,    3,    0,    1,
     &     7,    3,    4,    0,    2,    4,    0,    6,    1,    5,
     &     1,    1,    2,    3,    9,    0,    2,    4,    0,    6,
     &     2,    3,    0,    1,    7,    3,    5,    0,    1,    2,
     &     4,    0,    0,    1,    2,    8,    4,    5,    1,    3,
     &     5,    0,    1,    7,    2,    0,    6,    2,    2,    3,
     &     4,   10,    0,    1,    3,    5,    0,    1,    7,    3,
     &     4,    0,    0,    1,    2,    8,    4,    0,    6,    1,
     &     2,    3,    5,    1,    1,    2,    3,    9,    5,    0,
     &     6,    2,    4,    0,    0,    6,    1,    2,    8,    3,
     &     0,    1,    7,    3,    3,    4,    5,    0,   11,    1 /
      DATA (IN2(I), I = 191, 316) /
     &     2,    4,    0,    0,    6,    1,    2,    8,    4,    5,
     &     0,    1,    1,    2,    3,    9,    5,    0,    1,    7,
     &     2,    3,    4,    0,    6,    2,    2,    3,    4,   10,
     &     0,    0,    6,    1,    7,    3,    5,    0,    1,    1,
     &     7,    2,    3,    9,    4,    0,    0,    1,    2,    8,
     &     4,    4,    0,    5,    6,    1,   12,    2,    3,    5,
     &     1,    0,    1,    7,    2,    3,    9,    5,    0,    6,
     &     1,    2,    2,    3,    4,    0,   10,    0,    6,    1,
     &     2,    8,    3,    4,    5,    0,    1,    7,    3,    3,
     &     4,    5,    0,    0,   11,    1,    1,    7,    2,    8,
     &     4,    0,    0,    6,    1,    2,    2,    8,    3,    4,
     &    10,    5,    0,    1,    1,    2,    3,    9,    5,    5,
     &     0,    1,    6,    7,    2,   13 /
C
       DATA (IN3(I), I = 1, 190) /
     &     0,    1,    0,    0,    1,    0,    0,    2,    0,    1,
     &     0,    1,    0,    2,    0,    1,    1,    0,    3,    0,
     &     1,    0,    0,    2,    0,    1,    2,    1,    0,    0,
     &     3,    0,    1,    2,    0,    0,    2,    1,    0,    4,
     &     1,    2,    1,    0,    0,    1,    3,    0,    1,    0,
     &     2,    0,    3,    0,    2,    1,    1,    0,    4,    1,
     &     0,    2,    3,    1,    0,    0,    1,    3,    0,    2,
     &     1,    5,    0,    0,    2,    0,    3,    0,    2,    1,
     &     1,    2,    0,    4,    1,    0,    0,    2,    1,    3,
     &     1,    0,    0,    4,    1,    3,    2,    0,    2,    1,
     &     5,    0,    0,    2,    0,    1,    3,    0,    4,    2,
     &     1,    1,    0,    2,    0,    4,    1,    3,    0,    0,
     &     2,    6,    1,    1,    3,    1,    0,    0,    4,    1,
     &     3,    0,    2,    0,    2,    3,    1,    5,    0,    0,
     &     2,    0,    1,    1,    3,    0,    2,    4,    2,    1,
     &     1,    5,    0,    0,    2,    0,    4,    3,    1,    3,
     &     0,    0,    2,    6,    1,    1,    3,    1,    0,    2,
     &     0,    4,    1,    5,    0,    3,    0,    2,    0,    2,
     &     1,    3,    1,    5,    0,    0,    2,    4,    0,    1 /
      DATA (IN3(I), I = 191, 316) /
     &     1,    3,    7,    2,    0,    2,    4,    2,    1,    1,
     &     0,    5,    0,    0,    2,    0,    4,    1,    3,    1,
     &     3,    0,    0,    4,    2,    6,    1,    1,    3,    1,
     &     2,    0,    0,    2,    0,    4,    1,    3,    5,    0,
     &     3,    0,    2,    0,    2,    6,    1,    1,    3,    1,
     &     5,    0,    4,    0,    2,    4,    0,    1,    1,    3,
     &     7,    0,    2,    0,    2,    4,    2,    1,    3,    1,
     &     0,    5,    0,    0,    2,    6,    0,    1,    4,    1,
     &     3,    1,    3,    0,    0,    2,    4,    2,    6,    1,
     &     1,    3,    5,    0,    1,    2,    0,    0,    2,    0,
     &     4,    8,    3,    1,    3,    5,    0,    3,    0,    2,
     &     0,    2,    1,    6,    1,    1,    3,    1,    5,    0,
     &     2,    4,    0,    2,    4,    0 /
C
       DATA (IN5(I), I = 1, 190) /
     &     0,    0,    0,    1,    0,    0,    0,    0,    1,    0,
     &     0,    1,    0,    0,    1,    0,    0,    2,    0,    0,
     &     1,    0,    1,    0,    1,    0,    1,    0,    0,    2,
     &     0,    0,    1,    0,    0,    1,    0,    2,    1,    0,
     &     0,    1,    0,    0,    2,    1,    0,    0,    1,    3,
     &     0,    0,    1,    1,    0,    0,    2,    1,    0,    0,
     &     2,    1,    0,    0,    0,    2,    1,    0,    0,    2,
     &     1,    0,    1,    3,    0,    0,    1,    1,    0,    0,
     &     2,    1,    1,    0,    0,    0,    2,    1,    3,    0,
     &     0,    0,    2,    1,    1,    0,    0,    0,    2,    1,
     &     0,    1,    3,    0,    0,    2,    1,    1,    0,    0,
     &     0,    2,    4,    1,    1,    0,    0,    2,    0,    2,
     &     1,    0,    1,    3,    0,    0,    0,    2,    1,    1,
     &     0,    3,    0,    0,    2,    1,    1,    0,    1,    3,
     &     0,    0,    0,    2,    1,    1,    3,    0,    0,    0,
     &     2,    1,    2,    4,    1,    1,    0,    0,    0,    2,
     &     0,    2,    1,    0,    1,    3,    0,    0,    0,    2,
     &     2,    1,    1,    0,    1,    0,    3,    0,    0,    2,
     &     4,    1,    1,    0,    1,    3,    0,    2,    0,    0 /
      DATA (IN5(I), I = 191, 316) /
     &     2,    1,    0,    1,    1,    3,    0,    0,    0,    2,
     &     0,    1,    2,    4,    1,    1,    0,    3,    0,    0,
     &     2,    0,    2,    1,    1,    0,    1,    3,    0,    0,
     &     0,    5,    0,    2,    2,    1,    1,    3,    0,    1,
     &     0,    3,    0,    0,    2,    1,    2,    4,    1,    1,
     &     0,    1,    0,    3,    0,    2,    0,    0,    2,    1,
     &     0,    4,    1,    1,    3,    0,    0,    0,    2,    2,
     &     0,    1,    2,    4,    1,    0,    1,    1,    0,    3,
     &     0,    0,    2,    0,    2,    4,    1,    1,    0,    1,
     &     3,    0,    2,    3,    0,    0,    5,    0,    2,    2,
     &     1,    0,    1,    1,    3,    0,    1,    0,    3,    0,
     &     0,    2,    0,    1,    2,    4,    1,    1,    0,    1,
     &     3,    0,    3,    0,    2,    0 /
C
       DATA (IN7(I), I = 1, 190) /
     &     0,    0,    0,    0,    0,    1,    0,    0,    0,    0,
     &     1,    0,    0,    0,    0,    1,    0,    0,    0,    1,
     &     0,    0,    1,    0,    0,    1,    0,    0,    2,    0,
     &     0,    1,    0,    1,    0,    1,    0,    0,    0,    0,
     &     1,    0,    0,    2,    0,    1,    0,    1,    0,    0,
     &     1,    0,    0,    1,    0,    2,    0,    0,    0,    1,
     &     1,    0,    1,    0,    2,    0,    1,    0,    1,    0,
     &     0,    0,    2,    0,    1,    0,    0,    1,    0,    2,
     &     0,    1,    0,    0,    1,    3,    1,    0,    0,    1,
     &     0,    2,    0,    0,    1,    0,    2,    1,    0,    0,
     &     0,    2,    0,    1,    0,    1,    0,    1,    1,    0,
     &     2,    0,    0,    1,    0,    0,    1,    0,    3,    1,
     &     0,    0,    2,    0,    1,    0,    2,    0,    0,    1,
     &     0,    1,    2,    1,    0,    1,    0,    0,    2,    0,
     &     1,    0,    3,    1,    0,    1,    0,    1,    0,    2,
     &     0,    0,    2,    0,    1,    0,    0,    2,    1,    0,
     &     3,    1,    0,    0,    2,    0,    1,    0,    2,    1,
     &     0,    0,    1,    1,    3,    0,    1,    2,    1,    0,
     &     0,    1,    0,    0,    2,    0,    1,    0,    0,    3 /
      DATA (IN7(I), I = 191, 316) /
     &     1,    0,    0,    2,    1,    0,    1,    0,    2,    0,
     &     4,    0,    2,    0,    1,    0,    0,    1,    2,    1,
     &     0,    3,    1,    1,    0,    0,    2,    0,    1,    0,
     &     3,    0,    2,    1,    0,    0,    1,    0,    1,    3,
     &     0,    1,    2,    1,    0,    0,    2,    0,    1,    0,
     &     0,    2,    2,    0,    1,    0,    0,    3,    1,    0,
     &     0,    1,    2,    1,    0,    1,    0,    2,    1,    0,
     &     4,    0,    2,    0,    1,    1,    0,    3,    0,    1,
     &     2,    1,    0,    3,    1,    0,    1,    0,    0,    2,
     &     0,    1,    0,    2,    0,    3,    0,    2,    1,    0,
     &     0,    0,    2,    1,    0,    1,    3,    0,    1,    2,
     &     1,    0,    4,    0,    2,    0,    1,    0,    0,    2,
     &     1,    2,    0,    1,    0,    0 /
C
C-----------------------------------------------------------------------
C
C     Test for input value beyond the tabel
C
      IF ( N .GT. NUM(MAX) ) GO TO 200
C
  100 CONTINUE
C
C      Use table look up method to find M
C
      I1 = 0
      I2 = MAX
  101 CONTINUE
      I = (I1 + I2) / 2
      M = NUM(I)
      IF      (M .LT. N) THEN
         I1 = I
      ELSE IF (M .GT. N) THEN
         I2 = I
      ELSE
         GO TO 150
      ENDIF
      IF (I2 .GT. I1+1) GO TO 101
C
      I = I2
      M = NUM(I)
C
  150 CONTINUE
C
C     Test for powers greater than MRAD
      IF ( MRAD .LT. 7 ) THEN
         IF ( IN7(I) .NE. 0 ) THEN
             I = I + 1
             M = NUM(I)
             GO TO 150
         ENDIF
         IF ( ( MRAD .LT. 5 ) .AND. ( IN5(I) .NE. 0 ) ) THEN
             I = I + 1
             M = NUM(I)
             GO TO 150
         ENDIF
         IF ( ( MRAD .LT. 3 ) .AND. ( IN3(I) .NE. 0 ) ) THEN
             I = I + 1
             M = NUM(I)
             GO TO 150
         ENDIF
      ENDIF
C     Set up exponents
      IPWR(1) = IN2(I)
      IPWR(2) = IN3(I)
      IPWR(3) = IN5(I)
      IPWR(4) = IN7(I)
      GO TO 800
C
  200 CONTINUE
C
C     Use iterative method to find M
C
C     Set M before entering factorization loop
C
      M = N - 1
C
  210 CONTINUE
C
C       Get next value of M for this pass and start factoring again
C
        M = M + 1
        ITMP = M
C        Initialize exponent values
        N2 = 0
        N3 = 0
        N5 = 0
        N7 = 0
C
  220    CONTINUE
C           Factor out powers of two
            ITEST = ITMP / 2
            IF (2*ITEST .EQ. ITMP) THEN
               ITMP = ITEST
               N2 = N2 + 1
               GO TO 220
            ENDIF
C
  230    CONTINUE
         IF ( MRAD .LT. 3 ) GO TO 299
C           Factor out powers of three
            ITEST = ITMP / 3
            IF (3*ITEST .EQ. ITMP) THEN
               ITMP = ITEST
               N3 = N3 + 1
               GO TO 230
            ENDIF
C
  250    CONTINUE
         IF ( MRAD .LT. 5 ) GO TO 299
C           Factor out powers of five
            ITEST = ITMP / 5
            IF (5*ITEST .EQ. ITMP) THEN
               ITMP = ITEST
               N5 = N5 + 1
               GO TO 250
            ENDIF
C
  270    CONTINUE
         IF ( MRAD .LT. 7 ) GO TO 299
C           Factor out powers of seven
            ITEST = ITMP / 7
            IF (7*ITEST .EQ. ITMP) THEN
               ITMP = ITEST
               N7 = N7 + 1
               GO TO 270
            ENDIF
C
  299     CONTINUE
C
C         If factoring did not complete, repeat factoring with bigger number
C
          IF ( ITMP .NE. 1 ) GO TO 210
C
C     Set up exponents
      IPWR(1) = N2
      IPWR(2) = N3
      IPWR(3) = N5
      IPWR(4) = N7
C
  800 CONTINUE
C
      RETURN
      END
