C***** NRFFT     N ROUTINE FOR REAL FFT'S    MTHADV EXT    REL 1.0
C
C   ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT:
C
C       CALL NRFFT( N, MRAD, M, IPWR )
C
C       where
C
C       N       Integer input number to be evaluated
C
C       MRAD    Integer input value for the maximum radix to be used
C
C       M       Integer output value for the smallest legal value
C
C       IPWR    Integer output vector of length four that has the
C               exponents of 2, 3, 5, and 7 for the number M
C
C   DESCRIPTION:
C       This routine is given the input integer N and returns the integer
C       M such that M is the smallest even number greater than or equal to
C       N such that M = 2**I * 3**J * 5**K * 7**L where I, J, K, and L
C       are non-negative integers. J, K and L will be forced to zero
C       if the value of MRAD is less than 3. K and L will be forced to
C       zero if the value of MRAD is less than 5. L will be forced to zero
C       if the value of MRAD is less than 7. If MRAD is less than 2, a
C       value of 2 will be used.
C
C       The output vector IPWR contains the four exponents to form the
C       number M from powers of 2, 3, 5 and 7 respectively.
C
C       This routine will divide out a power of 2 from the number forcing
C       it to an even number and then call NCFFT to determine the value of
C       M and the value of the exponents
C
C
C
C  REFERENCES:
C
C       NONE
C
C  EXAMPLE:
C
C       CALL NRFFT( N, MRAD, M, IPWR )
C
C       INPUT OPERANDS:
C
C       N    =     1025
C
C       MRAD =     7
C
C       OUTPUT OPERANDS:
C
C       M    =     1050
C
C       IPWR =     1
C                  1
C                  2
C                  1
C
C  SUBPROGRAMS:
C
C       NCFFT
C
C  HISTORY:
C
C       1) June 1988              P.G. Crose               Original
C
C  ERROR CONDITIONS:
C       NONE.
C
C
C---------------------------------------------------------------------
C
      SUBROUTINE NRFFT (N, MRAD, M, IPWR)
C
      INTEGER N, MRAD, M, IPWR(4)
C
      INTEGER ITMP
C
C---------------------------------------------------------------------
C
C     Test for value less than or equal to 2
C
      IF ( N .LE. 2 ) THEN
          M = 2
          IPWR(1) = 1
          IPWR(2) = 0
          IPWR(3) = 0
          IPWR(4) = 0
C
          RETURN
      ENDIF
C
C     Force value to be even
C
      ITMP = N/2
C
      IF ( ITMP*2 .NE. N ) THEN
          ITMP = ITMP + 1
      ENDIF
C
      CALL NCFFT( ITMP, MRAD, M, IPWR )
C
C     Adjust output values for dividing out factor of 2.
C
      IPWR(1) = IPWR(1) + 1
      M = M + M
C
      RETURN
      END
