C*****  PKVAL  Peak and Valley                       MTHADV EXT. REL 1.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL PKVAL (A,N,IFLG,R,VPV,IPV,M,NPV)
C
C       where,
C
C       A       Real input vector, non-negative values.
C
C       N       Integer input length of vector A.
C
C       IFLG    Integer input processing option flag:
C                   =0 for peak mode initially.
C                   =1 for valley mode initially.
C
C       R       Real input scalar, threshold ratio.
C               NOTE: if R .LE. 1.0
C                       successive values that are equal will be
C                       defined as peaks or valleys.
C
C       VPV     Real output vector, peak and valley vector.
C
C       IPV     Integer output vector, index vector.
C
C       M       Integer input vector length of VPV and IPV.
C
C       NPV     Integer output number of peaks and valleys detected.
C
C
C  DESCRIPTION
C
C       This routine detects peaks and valleys in vector A data and
C       produces vector VPV containing the peaks and valleys, and vector
C       IPV contcontains the indices of these peaks and valleys.
C
C       PKVAL will search for either a peak first or a valley first,
C       depending on the value of IFLG.
C
C       A peak is selected if all the subsequent element values are less
C       than the current suspect value up to, and including, the element
C       whose value is less by the source threshold factor 1/R.
C
C       A valley is selected if all the subsequent element values are
C       greater than the current suspect value up to, and including, the
C       element whose value is greater by the source threshold factor R.
C
C       Once the peak or valley is obtained, its value and corresponding
C       index are stored in the next element of arrays VPV and IPV,
C       respectively.
C
C       This process is repeated until either M peaks and valleys have
C       been found, or until N elements of A have been examined.
C
C
C  EXAMPLE
C
C       CALL PKVAL (A,N,IFLG,R,VPV,IPV,M,NPV)
C       CALL PKVAL (A,12,0,R,VPV,IPV,3,NPV)
C
C       Input Operands:
C
C       A = 1.00   R = 1.1
C           2.00
C           3.00
C           2.50
C           5.00
C           4.95
C           4.90
C           6.00
C           7.00
C           6.95
C           5.00
C           2.00
C
C       Output Operands:
C
C       VPV = 3.0     IVP = 3     NPV = 3
C             2.5           4
C             7.0           9
C
C  HISTORY
C         1) Nov 86     C. Vallens      Original.
C         2) Dec 86     L. Tarvestad    Remove subset array features.
C                                       Add standard header.
C
C-----------------------------------------------------------------------
C
       SUBROUTINE PKVAL (A, N, IFLG, R, VPV, IPV, M, NPV)
C
       INTEGER N, IFLG, IPV(1), M, NPV, I, J, K
       REAL A(1), R, VPV(1), MINMAX
C
C-----------------------------------------------------------------------
C
       IF (N.LE.0 .OR. M.LE.0 .OR. IFLG.LT.0 .OR. IFLG.GT.1) GO TO 99
C
C INITIALIZATION
       I = 1
       MINMAX = A(1)
       NPV = 0
       J = 1
C
C BRANCH ON SELECTED START MODE
       IF (IFLG .NE. 0) GO TO 50
C
C SEARCH FOR NEW PEAK
10     K = 0
20     K = K + 1
       IF ( I+K .GT. N) GO TO 99
       IF ( A(I) .GE. A(I+K) ) GO TO 30
       MINMAX = A(I+K)
       I = I + K
       GO TO 10
C
C POTENTIAL NEW PEAK.  IF SO, SAVE VALUE/INDEX; ELSE BRANCH BACK.
30     IF ( MINMAX .LT. R*A(I+K) ) GO TO 20
       VPV(J) = MINMAX
       IPV(J) = I
       NPV = NPV + 1
       J = J + 1
       IF (J .GT. M) GO TO 99
       I = I + 1
       MINMAX = A(I)
C
C SEARCH FOR NEW VALLEY
50     K = 0
60     K = K + 1
       IF ( I+K .GT. N) GO TO 99
       IF ( A(I) .LE. A(I+K) ) GO TO 70
       MINMAX = A(I+K)
       I = I + K
       GO TO 50
C
C POTENTIAL NEW VALLEY.  IF SO, SAVE VALUE/INDEX; ELSE BRANCH BACK.
70     IF ( MINMAX*R .GT. A(I+K) ) GO TO 60
       VPV(J) = MINMAX
       IPV(J) = I
       NPV = NPV + 1
       J = J + 1
       IF (J .GT. M) GO TO 99
       I = I + 1
       MINMAX = A(I)
       GO TO 10
C
99     RETURN
       END
