C***** POLYDV   POLYNOMIAL DIVIDE                    MTHADV EXT  REL 1.0
C
C   ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL POLYDV( A, B, C, N, M, L )
C
C       where
C
C       A       Real input vector of polynomial coeficients for the dividend.
C
C       B       Real input vector of polynomial coeficients for the divisor.
C
C       C       Real output vector of polynomial coeficients for the quotient.
C
C       N       Integer input number of elements in A.
C
C       M       Integer input number of elements in B,
C
C       L       Integer input number of elements in C,
C
C
C  DESCRIPTION:
C
C       This routine divided one polynomial by another.
C
C               C(z) = A(z) / B(z)
C
C
C               where:
C
C               A(z) = a0 + a1*z**1 + ... + an*z**n
C               B(z) = b0 + b1*z**1 + ... + bn*z**m
C               C(z) = c0 + c1*z**1 + ... + cl*z**l
C
C               N = n+1
C               M = m+1
C               L = l+1
C
C       NOTE:   IF b0 = 0.0, C will be set to all zero.
C               The code assumes that C may be initialized from A
C               without considering data overlap of the two vectors.
C               This means that the movement of data from A to C
C               must not cause any of the first N elements of A to
C               be changed.
C
C
C  REFERENCES:
C
C       Robinson E. A.  1983,  Multichannel Time Series Analysis
C       (Goose Pond Press, Houston Texas),  pp 30, 31
C
C  EXAMPLE:
C
C       CALL POLYDV( A, B, C, 1, 2, 5 )
C
C       INPUT OPERANDS:
C
C       A  =    1.0
C
C       B  =    1.0
C               -0.5
C
C
C       OUTPUT OPERANDS:
C
C       C  =    1.0
C               0.5
C               0.25
C               0.125
C               0.0625
C
C
C  SUBPROGRAMS:
C
C       INTRINSICS:     MIN
C
C
C  HISTORY:
C       1) May 1988          P. G. Crose               Original
C       2) Oct 1988          D. P. Madura              Fixed iteration count
C                                                      for 'DO 1' loop
C
C----------------------------------------------------------------------------
C
        SUBROUTINE POLYDV( A, B, C, N, M, L )
C
        REAL A(*), B(*), C(*)
        INTEGER N, M, L
C
        INTEGER I, J, K, II
C
C----------------------------------------------------------------------------
C
C
C         PUT ZERO IN THE ELEMENTS OF C
        DO 1 I = 1, L
                C(I) = 0.0
 1      CONTINUE
C
C         TEST FOR B(1) .NE. 0.0
C
        IF ( B(1) .NE. 0.0 )  THEN
C
C         INITIALIZE C WITH VALUES FROM A
C         !! WARNING !!  THIS CODE DOES NOT CHECK FOR DATA OVERLAP
C
        DO 2 I = 1, MIN( N, L )
                C(I) = A(I)
 2      CONTINUE
C
C         PERFORM DIVISION
C
        DO 10 I = 1, L
            C(I) = C(I) / B(1)
            IF( I .NE. L ) THEN
                K = I
                II = MIN( M - 1 , L - 1 )
                DO 9 J = 1, II
                    K = K + 1
                    C(K) = C(K) - C(I) * B(J+1)
 9              CONTINUE
C
            ENDIF
 10     CONTINUE
C
        ENDIF
        RETURN
        END
