C*****  QTC005  MATH ADVANTAGE Private Subroutine CONVG
C
      SUBROUTINE QTC005(A,NRA,B,NRB,C,NCB)
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
      REAL A(1),B(1),C
      INTEGER NRA,NRB,NCB,I,J,IRA,IB,JB
C     CONVOLUTION -- REVERSE THE USE OF B:
      JB = NRB*NCB
      C = 0.0
      DO 199 I = 1,NRB
C
C     FOR ALL ROWS OF A AND B,
C     DOT ONE ROW OF A WITH THE CORRESPONDING ROW OF B.
C     THIS IS EQUIVALENT TO
C       'CALL RNDOTP(A(I),NRA,0,B(JB),-NRB,0,C,0,NCB,1,6)'
C     FOLLOWED BY
C       'JB = JB - 1'
C
        IRA  = I
        IB  = JB - (I-1)
        DO 99 J = 1,NCB
          C = C + A(IRA) * B(IB)
          IRA  = IRA + NRA
          IB  = IB - NRB
 99     CONTINUE
199   CONTINUE
      RETURN
      END
