C*****  QTC015  MATH ADVANTAGE Private Subroutine R8TR
C
C   ***** RADIX 8 ITERATION SUBROUTINE            *****
C----------------------------------------------------------------------
C  SUBROUTINE:  QTC015(=R8TR)
C  RADIX 8 ITERATION SUBROUTINE
C----------------------------------------------------------------------
C
      SUBROUTINE QTC015(INT, NN, BR0, BR1, BR2, BR3, BR4, BR5, BR6, BR7,
     *    BI0, BI1, BI2, BI3, BI4, BI5, BI6, BI7, DI)
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
      INTEGER INT,NN,J,K,J0,K0,JLAST,KL,INT8,DI
      INTEGER NEWJ,NEWK
      INTEGER JI,JL,JR,J1,J2,J3,J4,J5,J6,J7
      INTEGER J8,J9,J10,J11,J12,J13,J14,JTHET
      INTEGER L(15),L1,L2,L3,L4,L5,L6,L7,L8,L9,L10,L11,L12,L13,L14,L15
      REAL  BR0(2), BR1(2), BR2(2), BR3(2), BR4(2), BR5(2),
     *    BR6(2), BR7(2), BI0(2), BI1(2), BI2(2), BI3(2), BI4(2),
     *    BI5(2), BI6(2), BI7(2)
      REAL PII,P7,P7TWO,C22,S22,PI2,PIOVN,TH2,PR,PI
      REAL C1,S1,C2,S2,C3,S3,C4,S4,C5,S5,C6,S6,C7,S7
      REAL TI0,TI1,TI2,TI3,TI4,TI5,TI6,TI7
      REAL TR0,TR1,TR2,TR3,TR4,TR5,TR6,TR7
      REAL T0,T1,T2,T3,T4,T5,T6,T7,ARG
      EQUIVALENCE (L15,L(1)), (L14,L(2)), (L13,L(3)), (L12,L(4)),
     *    (L11,L(5)), (L10,L(6)), (L9,L(7)), (L8,L(8)), (L7,L(9)),
     *    (L6,L(10)), (L5,L(11)), (L4,L(12)), (L3,L(13)), (L2,L(14)),
     *    (L1,L(15))
C
C  SET UP COUNTERS SUCH THAT JTHET STEPS THROUGH THE ARGUMENTS
C  OF W, JR STEPS THROUGH STARTING LOCATIONS FOR THE REAL PART OF THE
C  INTERMEDIATE RESULTS AND JI STEPS THROUGH STARTING LOCATIONS
C  OF THE IMAGINARY PART OF THE INTERMEDIATE RESULTS.
C
      IF (INT.LT.1) GOTO 150
      PII = 4.0 * ATAN(1.0)
      PI2 = PII + PII
      P7 =  SQRT(0.5)
      P7TWO = P7 + P7
      C22 = COS(PII/8.0)
      S22 = SIN(PII/8.0)
      L(1) = NN/8
      DO 40 K=2,15
        IF (L(K-1)-2) 10,20, 30
10      L(K-1) = 2
20      L(K) = 2
        GO TO 40
30      L(K) = L(K-1)/2
40    CONTINUE
      PIOVN = PII/FLOAT(NN)
      JI = 3
      JL = 2
      JR = 2
      DO 120 J1=2,L1,2
      DO 120 J2=J1,L2,L1
      DO 120 J3=J2,L3,L2
      DO 120 J4=J3,L4,L3
      DO 120 J5=J4,L5,L4
      DO 120 J6=J5,L6,L5
      DO 120 J7=J6,L7,L6
      DO 120 J8=J7,L8,L7
      DO 120 J9=J8,L9,L8
      DO 120 J10=J9,L10,L9
      DO 120 J11=J10,L11,L10
      DO 120 J12=J11,L12,L11
      DO 120 J13=J12,L13,L12
      DO 120 J14=J13,L14,L13
      DO 120 JTHET=J14,L15,L14
        TH2 = FLOAT(JTHET-2)
        IF (TH2) 50, 50, 90
50      DO 60 K=1,INT
          NEWK = (K-1) * DI + 1
          T0 = BR0(NEWK) + BR4(NEWK)
          T1 = BR1(NEWK) + BR5(NEWK)
          T2 = BR2(NEWK) + BR6(NEWK)
          T3 = BR3(NEWK) + BR7(NEWK)
          T4 = BR0(NEWK) - BR4(NEWK)
          T5 = BR1(NEWK) - BR5(NEWK)
          T6 = BR2(NEWK) - BR6(NEWK)
          T7 = BR3(NEWK) - BR7(NEWK)
          BR2(NEWK) = T0 - T2
          BR3(NEWK) = T1 - T3
          T0 = T0 + T2
          T1 = T1 + T3
          BR0(NEWK) = T0 + T1
          BR1(NEWK) = T0 - T1
          PR = P7*(T5-T7)
          PI = P7*(T5+T7)
          BR4(NEWK) = T4 + PR
          BR7(NEWK) = T6 + PI
          BR6(NEWK) = T4 - PR
          BR5(NEWK) = PI - T6
60      CONTINUE
        IF (NN-8) 120, 120, 70
70      K0 = INT*8 + 1
        KL = K0 + INT - 1
        DO 80 K=K0,KL
          NEWK = (K-1) * DI + 1
          PR = P7*(BI2(NEWK)-BI6(NEWK))
          PI = P7*(BI2(NEWK)+BI6(NEWK))
          TR0 = BI0(NEWK) + PR
          TI0 = BI4(NEWK) + PI
          TR2 = BI0(NEWK) - PR
          TI2 = BI4(NEWK) - PI
          PR = P7*(BI3(NEWK)-BI7(NEWK))
          PI = P7*(BI3(NEWK)+BI7(NEWK))
          TR1 = BI1(NEWK) + PR
          TI1 = BI5(NEWK) + PI
          TR3 = BI1(NEWK) - PR
          TI3 = BI5(NEWK) - PI
          PR = TR1*C22 - TI1*S22
          PI = TI1*C22 + TR1*S22
          BI0(NEWK) = TR0 + PR
          BI6(NEWK) = TR0 - PR
          BI7(NEWK) = TI0 + PI
          BI1(NEWK) = PI - TI0
          PR = -TR3*S22 - TI3*C22
          PI = TR3*C22 - TI3*S22
          BI2(NEWK) = TR2 + PR
          BI4(NEWK) = TR2 - PR
          BI5(NEWK) = TI2 + PI
          BI3(NEWK) = PI - TI2
80      CONTINUE
        GO TO 120
90      ARG = TH2*PIOVN
        C1 = COS(ARG)
        S1 = SIN(ARG)
        C2 = C1**2 - S1**2
        S2 = C1*S1 + C1*S1
        C3 = C1*C2 - S1*S2
        S3 = C2*S1 + S2*C1
        C4 = C2**2 - S2**2
        S4 = C2*S2 + C2*S2
        C5 = C2*C3 - S2*S3
        S5 = C3*S2 + S3*C2
        C6 = C3**2 - S3**2
        S6 = C3*S3 + C3*S3
        C7 = C3*C4 - S3*S4
        S7 = C4*S3 + S4*C3
        INT8 = INT*8
        J0 = JR*INT8 + 1
        K0 = JI*INT8 + 1
        JLAST = J0 + INT - 1
        DO 100 J=J0,JLAST
            NEWJ = (J-1) * DI + 1
            K = K0 + J - J0
            NEWK = (K-1) * DI + 1
            TR1 = BR1(NEWJ)*C1 - BI1(NEWK)*S1
            TI1 = BR1(NEWJ)*S1 + BI1(NEWK)*C1
            TR2 = BR2(NEWJ)*C2 - BI2(NEWK)*S2
            TI2 = BR2(NEWJ)*S2 + BI2(NEWK)*C2
            TR3 = BR3(NEWJ)*C3 - BI3(NEWK)*S3
            TI3 = BR3(NEWJ)*S3 + BI3(NEWK)*C3
            TR4 = BR4(NEWJ)*C4 - BI4(NEWK)*S4
            TI4 = BR4(NEWJ)*S4 + BI4(NEWK)*C4
            TR5 = BR5(NEWJ)*C5 - BI5(NEWK)*S5
            TI5 = BR5(NEWJ)*S5 + BI5(NEWK)*C5
            TR6 = BR6(NEWJ)*C6 - BI6(NEWK)*S6
            TI6 = BR6(NEWJ)*S6 + BI6(NEWK)*C6
            TR7 = BR7(NEWJ)*C7 - BI7(NEWK)*S7
            TI7 = BR7(NEWJ)*S7 + BI7(NEWK)*C7
C
            T0 = BR0(NEWJ) + TR4
            T1 = BI0(NEWK) + TI4
            TR4 = BR0(NEWJ) - TR4
            TI4 = BI0(NEWK) - TI4
            T2 = TR1 + TR5
            T3 = TI1 + TI5
            TR5 = TR1 - TR5
            TI5 = TI1 - TI5
            T4 = TR2 + TR6
            T5 = TI2 + TI6
            TR6 = TR2 - TR6
            TI6 = TI2 - TI6
            T6 = TR3 + TR7
            T7 = TI3 + TI7
            TR7 = TR3 - TR7
            TI7 = TI3 - TI7
C
            TR0 = T0 + T4
            TI0 = T1 + T5
            TR2 = T0 - T4
            TI2 = T1 - T5
            TR1 = T2 + T6
            TI1 = T3 + T7
            TR3 = T2 - T6
            TI3 = T3 - T7
            T0 = TR4 - TI6
            T1 = TI4 + TR6
            T4 = TR4 + TI6
            T5 = TI4 - TR6
            T2 = TR5 - TI7
            T3 = TI5 + TR7
            T6 = TR5 + TI7
            T7 = TI5 - TR7
            BR0(NEWJ) = TR0 + TR1
            BI7(NEWK) = TI0 + TI1
            BI6(NEWK) = TR0 - TR1
            BR1(NEWJ) = TI1 - TI0
            BR2(NEWJ) = TR2 - TI3
            BI5(NEWK) = TI2 + TR3
            BI4(NEWK) = TR2 + TI3
            BR3(NEWJ) = TR3 - TI2
            PR = P7*(T2-T3)
            PI = P7*(T2+T3)
            BR4(NEWJ) = T0 + PR
            BI3(NEWK) = T1 + PI
            BI2(NEWK) = T0 - PR
            BR5(NEWJ) = PI - T1
            PR = -P7*(T6+T7)
            PI = P7*(T6-T7)
            BR6(NEWJ) = T4 + PR
            BI1(NEWK) = T5 + PI
            BI0(NEWK) = T4 - PR
            BR7(NEWJ) = PI - T5
 100      CONTINUE
          JR = JR + 2
          JI = JI - 2
          IF (JI-JL) 110, 110, 120
 110      JI = 2*JR - 1
          JL = JR
 120    CONTINUE
150     RETURN
        END
