C*****  QTC026  MATH ADVANTAGE Private Subroutine RAND
C
C **** QTC026(=RAND) Uniform random number generator
C                       MATH ADVANTAGE REL 3.0
C    **       COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C      X = QTC026(I)
C
C      where,
C
C      X      Real output value
C
C      I      Integer seed value
C
C
C  DESCRIPTION
C
C      This function generates a pseudorandom number, uniformly distributed
C      over the interval 0.0 < X < 1.0.
C
C      Calls to this function return one of a sequence of pseudorandom numbers
C      calculated by a routine derived from the Data Encryption Standard
C      developed by the National Security Agency.  A new sequence is
C      started each time the seed value is changed.
C
C      If a value is chosen for ISEED, then repeated calls to this
C      function are made, a particular sequence of values will be returned.
C      Each different value of ISEED will result in a different sequence
C      of values - however, the sequence is identical each time a particular
C      value of ISEED is used.
C
C      The values returned by this routine are not truly random, as they
C      repeat with a cycle length of approximately 16 * 2**31.  This cycle
C      length is suitable for most purposes.  Moreover, all bits of the
C      returned value are random, uniformly distributed, and uncorrelated.
C
C      This routine is slow.  Use of this routine is advised only when
C      a system-supplied routine is not available, or when the randomness
C      of the system-supplied routine is not adequate.
C
C
C      EXAMPLE
C
C      I = 1234
C      X = QTC026(I)
C
C  HISTORY
C
C      1) August 1986       L. A. Westerman
C      2) January 1987      L. Shanbeck
C             Changed DATA statement initialization to use EQUIVALENCE
C
        REAL FUNCTION QTC026(ISEED)
        INTEGER ISEED
C
C   REQUIRED STORAGE
C
       INTEGER I, ICOL, IROW, ISS, ISTART
       INTEGER J, JSEED, K, KI, KK
       INTEGER IBIN(4,16), IE(48), IET(48), II(16)
       INTEGER IP(32), IR(32), ITMP(32)
       INTEGER IS(16,4,8), IS1(64), IS2(64), IS3(64), IS4(64),
     1                     IS5(64), IS6(64), IS7(64), IS8(64)
       REAL X, RI(32)
       EQUIVALENCE (IS(1,1,1),IS1(1)), (IS(1,1,2),IS2(1)),
     1             (IS(1,1,3),IS3(1)), (IS(1,1,4),IS4(1)),
     1             (IS(1,1,5),IS5(1)), (IS(1,1,6),IS6(1)),
     1             (IS(1,1,7),IS7(1)), (IS(1,1,8),IS8(1))
C
C      THIS SAVE STATEMENT EXISTS TO FORCE 'STATIC' MEMORY ALLOCATION
C      OF ALL REQUIRED INTERNAL VARIABLES
C
       SAVE IBIN, IET, II, IP, IR, IS, RI, JSEED, ISTART
       DATA JSEED / -1 /
       DATA ISTART /1/
       DATA RI / 32 * 0.0 /
C
C      INITIALIZATION PATTERN FOR ODD IR BITS
C
        DATA II / 2,1,2,2,1,2,1,2,1,2,1,1,2,2,2,1/
C
C      DATA TO EXPAND 32 BIT ARRAY TO 48 BITS
C
        DATA IET/32,1,2,3,4,5,4,5,6,7,8,9,8,9,10,11,12,13,12,13,
     1 14,15,16,17,16,17,18,19,20,21,20,21,22,23,24,
     1 25,24,25,26,27,28,29,28,29,30,31,32,1/
C
C      DATA FOR OUTGOING BIT PERMUTATION
C
        DATA IP/16,7,20,21,29,12,28,17,1,15,23,26,5,18,31,10,
     1 2,8,24,14,32,27,3,9,19,13,30,6,22,11,4,25/
C
C      DATA FOR BINARY BIT SUBSTITUTION
C
        DATA IBIN /
     1  1,1,1,1, 1,1,1,2, 1,1,2,1, 1,1,2,2,
     1  1,2,1,1, 1,2,1,2, 1,2,2,1, 1,2,2,2,
     1  2,1,1,1, 2,1,1,2, 2,1,2,1, 2,1,2,2,
     1  2,2,1,1, 2,2,1,2, 2,2,2,1, 2,2,2,2 /
C
C      DATA FOR 'S-BOX'
C
C                    ((IS(I,J,1),I=1,16),J=1,4)
        DATA IS1 /
     1 15,  5, 14,  2,  3, 16, 12,  9,  4, 11,  7, 13,  6, 10,  1,  8,
     1  1, 16,  8,  5, 15,  3, 14,  2, 11,  7, 13, 12, 10,  6,  4,  9,
     1  5,  2, 15,  9, 14,  7,  3, 12, 16, 13, 10,  8,  4, 11,  6,  1,
     1 16, 13,  9,  3,  5, 10,  2,  8,  6, 12,  4, 15, 11,  1,  7, 14/
C                    ((IS(I,J,2),I=1,16),J=1,4)
        DATA IS2 /
     1 16,  2,  9, 15,  7, 12,  4,  5, 10,  8,  3, 14, 13,  1,  6, 11,
     1  4, 14,  5,  8, 16,  3,  9, 15, 13,  1,  2, 11,  7, 10, 12,  6,
     1  1, 15,  8, 12, 11,  5, 14,  2,  6,  9, 13,  7, 10,  4,  3, 16,
     1 14,  9, 11,  2,  4, 16,  5,  3, 12,  7,  8, 13,  1,  6, 15, 10/
C                    ((IS(I,J,3),I=1,16),J=1,4)
        DATA IS3 /
     1 11,  1, 10, 15,  7,  4, 16,  6,  2, 14, 13,  8, 12,  5,  3,  9,
     1 14,  8,  1, 10,  4,  5,  7, 11,  3,  9,  6, 15, 13, 12, 16,  2,
     1 14,  7,  5, 10,  9, 16,  4,  1, 12,  2,  3, 13,  6, 11, 15,  8,
     1  2, 11, 14,  1,  7, 10,  9,  8,  5, 16, 15,  4, 12,  6,  3, 13/
C                    ((IS(I,J,4),I=1,16),J=1,4)
        DATA IS4 /
     1  8, 14, 15,  4,  1,  7, 10, 11,  2,  3,  9,  6, 12, 13,  5, 16,
     1 14,  9, 12,  6,  7, 16,  1,  4,  5,  8,  3, 13,  2, 11, 15, 10,
     1 11,  7, 10,  1, 13, 12,  8, 14, 16,  2,  4, 15,  6,  3,  9,  5,
     1  4, 16,  1,  7, 11,  2, 14,  9, 10,  5,  6, 12, 13,  8,  3, 15/
C                    ((IS(I,J,5),I=1,16),J=1,4)
        DATA IS5 /
     1  3, 13,  5,  2,  8, 11, 12,  7,  9,  6,  4, 16, 14,  1, 15, 10,
     1 15, 12,  3, 13,  5,  8, 14,  2,  6,  1, 16, 11,  4, 10,  9,  7,
     1  5,  3,  2, 12, 11, 14,  8,  9, 16, 10, 13,  6,  7,  4,  1, 15,
     1 12,  9, 13,  8,  2, 15,  3, 14,  7, 16,  1, 10, 11,  5,  6,  4/
C                    ((IS(I,J,6),I=1,16),J=1,4)
        DATA IS6 /
     1 13,  2, 11, 16, 10,  3,  7,  9,  1, 14,  4,  5, 15,  8,  6, 12,
     1 11, 16,  5,  3,  8, 13, 10,  6,  7,  2, 14, 15,  1, 12,  4,  9,
     1 10, 15, 16,  6,  3,  9, 13,  4,  8,  1,  5, 11,  2, 14, 12,  7,
     1  5,  4,  3, 13, 10,  6, 16, 11, 12, 15,  2,  8,  7,  1,  9, 14/
C                    ((IS(I,J,7),I=1,16),J=1,4)
        DATA IS7 /
     1  5, 12,  3, 15, 16,  1,  9, 14,  4, 13, 10,  8,  6, 11,  7,  2,
     1 14,  1, 12,  8,  5, 10,  2, 11, 15,  4,  6, 13,  3, 16,  9,  7,
     1  2,  5, 12, 14, 13,  4,  8, 15, 11, 16,  7,  9,  1,  6, 10,  3,
     1  7, 12, 14,  9,  2,  5, 11,  8, 10,  6,  1, 16, 15,  3,  4, 13/
C                    ((IS(I,J,8),I=1,16),J=1,4)
        DATA IS8 /
     1 14,  3,  9,  5,  7, 16, 12,  2, 11, 10,  4, 15,  6,  1, 13,  8,
     1  2, 16, 14,  9, 11,  4,  8,  5, 13,  6,  7, 12,  1, 15, 10,  3,
     1  8, 12,  5,  2, 10, 13, 15,  3,  1,  7, 11, 14, 16,  4,  6,  9,
     1  3,  2, 15,  8,  5, 11,  9, 14, 16, 13, 10,  1,  4,  6,  7, 12/
C
C       IF THE SEED IS NEW, INITIALIZE THE IR ARRAY
C
        IF ( ( ISEED .NE. JSEED ) .OR. ( ISTART .EQ. 1 ) ) THEN
           JSEED = ISEED
           K = 1
            DO 10 I = 1, 16
                IR(K) = II(I)
              K = K + 1
C
C      DETERMINE THE RIGHT-MOST BIT, ADD ONE TO IT, AND STORE IT IN IR()
C
              J = JSEED / 2
              IR(K) = JSEED - J - J + 1
              K = K + 1
                JSEED = J
10          CONTINUE
            JSEED = ISEED
        ENDIF
C
C       IF THIS IS THE FIRST CALL, SET UP THE REQUIRED CONSTANTS
C
C
       IF ( ISTART .EQ. 1 ) THEN
           X = 0.5
           DO 11 I = 1, 32
               RI(I) = X
               X = X / 2.0
11         CONTINUE
           ISTART = 0
       ENDIF
C
C       TRANSFER THE BITS, WHILE EXPANDING THE WORD
C
        DO 12 I = 1, 48
            IE(I) = IR(IET(I))
12      CONTINUE
C
C       NOW GENERATE THE NEW RANDOM SEQUENCE
C
        J = -5
        KK = 1
        DO 14 I = 1, 8
            J = J + 6
           IROW = IE(J+5)
           IF ( IE(J) .EQ. 2 ) THEN
              IROW = IROW + 2
           ENDIF
           ICOL = IE(J+4)
           IF ( IE(J+3) .EQ. 2 ) THEN
              ICOL = ICOL + 2
           ENDIF
           IF ( IE(J+2) .EQ. 2 ) THEN
              ICOL = ICOL + 4
           ENDIF
           IF ( IE(J+1) .EQ. 2 ) THEN
              ICOL = ICOL + 8
           ENDIF
C
           ISS  = IS(ICOL,IROW,I)
            DO 13 KI = 1, 4
                ITMP(KK) = IBIN(KI,ISS)
              KK = KK + 1
13          CONTINUE
14      CONTINUE
C
C       RECONSTITUTE THE CONDENSED RANDOM SEQUENCE
C      AND CALCULATE A REAL NUMBER BETWEEN 0.0 AND 1.0
C
       QTC026 = 0.0
        DO 15 I = 1, 32
            J = ITMP(IP(I))
           IR(I) = J
           IF ( J .EQ. 2 ) THEN
               QTC026 = QTC026 + RI(I)
           ENDIF
15      CONTINUE
C
        RETURN
C
        END
