C*****  QTC030  MATH ADVANTAGE Private Subroutine CBABK2
C       (EISPACK , August 1983 Version)
C
C  MODIFICATIONS to Standard EISPACK
C
C         o Store complex data as adjacent real/imaginary pairs, instead
C           of using one array for real components and a different array
C           for imaginary components.  This was implemented by, for
C           example, replacing the declarations ZR(NM,N) and ZI(NM,N)
C           with the declaration ZZ(2,NM,N).  All subsequent references
C           to ZR(i,j) are replaced with ZZ(1,i,j), and all references
C           to ZI(i,j) are replaced with ZZ(2,i,j).  The related change
C           is also made in the subroutine parameter list.
C
C  HISTORY
C         1) Sep 86     L. Tarvestad    Original.
C
      SUBROUTINE QTC030(NM,N,LOW,IGH,SCALE,M,ZZ)
C
      INTEGER I,J,K,M,N,II,NM,IGH,LOW
      REAL SCALE(N),ZZ(2,NM,M)
      REAL S
C
C     THIS SUBROUTINE IS A TRANSLATION OF THE ALGOL PROCEDURE
C     CBABK2, WHICH IS A COMPLEX VERSION OF BALBAK,
C     NUM. MATH. 13, 293-304(1969) BY PARLETT AND REINSCH.
C     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 315-326(1971).
C
C     THIS SUBROUTINE FORMS THE EIGENVECTORS OF A COMPLEX GENERAL
C     MATRIX BY BACK TRANSFORMING THOSE OF THE CORRESPONDING
C     BALANCED MATRIX DETERMINED BY QTC031.
C
C     ON INPUT
C
C        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL
C          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
C          DIMENSION STATEMENT.
C
C        N IS THE ORDER OF THE MATRIX.
C
C        LOW AND IGH ARE INTEGERS DETERMINED BY QTC031.
C
C        SCALE CONTAINS INFORMATION DETERMINING THE PERMUTATIONS
C          AND SCALING FACTORS USED BY QTC031.
C
C        M IS THE NUMBER OF EIGENVECTORS TO BE BACK TRANSFORMED.
C
C        ZR AND ZI CONTAIN THE REAL AND IMAGINARY PARTS,
C          RESPECTIVELY, OF THE EIGENVECTORS TO BE
C          BACK TRANSFORMED IN THEIR FIRST M COLUMNS.
C
C     ON OUTPUT
C
C        ZR AND ZI CONTAIN THE REAL AND IMAGINARY PARTS,
C          RESPECTIVELY, OF THE TRANSFORMED EIGENVECTORS
C          IN THEIR FIRST M COLUMNS.
C
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW,
C     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY
C
C     THIS VERSION DATED AUGUST 1983.
C
C     ------------------------------------------------------------------
C
      IF (M .EQ. 0) GO TO 200
      IF (IGH .EQ. LOW) GO TO 120
C
      DO 110 I = LOW, IGH
         S = SCALE(I)
C     .......... LEFT HAND EIGENVECTORS ARE BACK TRANSFORMED
C                IF THE FOREGOING STATEMENT IS REPLACED BY
C                S=1.0/SCALE(I). ..........
         DO 100 J = 1, M
            ZZ(1,I,J) = ZZ(1,I,J) * S
            ZZ(2,I,J) = ZZ(2,I,J) * S
  100    CONTINUE
C
  110 CONTINUE
C     .......... FOR I=LOW-1 STEP -1 UNTIL 1,
C                IGH+1 STEP 1 UNTIL N DO -- ..........
  120 DO 140 II = 1, N
         I = II
         IF (I .GE. LOW .AND. I .LE. IGH) GO TO 140
         IF (I .LT. LOW) I = LOW - II
         K = SCALE(I)
         IF (K .EQ. I) GO TO 140
C
         DO 130 J = 1, M
            S = ZZ(1,I,J)
            ZZ(1,I,J) = ZZ(1,K,J)
            ZZ(1,K,J) = S
            S = ZZ(2,I,J)
            ZZ(2,I,J) = ZZ(2,K,J)
            ZZ(2,K,J) = S
  130    CONTINUE
C
  140 CONTINUE
C
  200 RETURN
      END
