C*****  QTC033  MATH ADVANTAGE Private Subroutine COMQR2
C       (EISPACK , August 1983 Version)
C
C  MODIFICATIONS to Standard EISPACK
C
C         o Store complex data as adjacent real/imaginary pairs, instead
C           of using one array for real components and a different array
C           for imaginary components.  This was implemented by, for
C           example, replacing the declarations HH(NM,N) and HH(NM,N)
C           with the declaration HH(2,NM,N).  All subsequent references
C           to HR(i,j) are replaced with HH(1,i,j), and all references
C           to HI(i,j) are replaced with HH(2,i,j).  The related change
C           is also made in the subroutine parameter list.
C
C  HISTORY
C         1) Sep 86     L. Tarvestad    Original.
C
      SUBROUTINE QTC033(NM,N,LOW,IGH,ORT,HH,WW,ZZ,IERR)
C
      INTEGER I,J,K,L,M,N,EN,II,JJ,LL,NM,NN,IGH,IP1,
     X        ITN,ITS,LOW,LP1,ENM1,IEND,IERR
      REAL HH(2,NM,N),WW(2,N),ZZ(2,NM,N),ORT(2,IGH)
      REAL SI,SR,TI,TR,XI,XR,YI,YR,ZZI,ZZR,NORM,TST1,TST2,
     X       QTC041
C
C     THIS SUBROUTINE IS A TRANSLATION OF A UNITARY ANALOGUE OF THE
C     ALGOL PROCEDURE  COMLR2, NUM. MATH. 16, 181-204(1970) BY PETERS
C     AND WILKINSON.
C     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 372-395(1971).
C     THE UNITARY ANALOGUE SUBSTITUTES THE QR ALGORITHM OF FRANCIS
C     (COMP. JOUR. 4, 332-345(1962)) FOR THE LR ALGORITHM.
C
C     THIS SUBROUTINE FINDS THE EIGENVALUES AND EIGENVECTORS
C     OF A COMPLEX UPPER HESSENBERG MATRIX BY THE QR
C     METHOD.  THE EIGENVECTORS OF A COMPLEX GENERAL MATRIX
C     CAN ALSO BE FOUND IF QTC034 HAS BEEN USED TO REDUCE
C     THIS GENERAL MATRIX TO HESSENBERG FORM.
C
C     ON INPUT
C
C        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL
C          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
C          DIMENSION STATEMENT.
C
C        N IS THE ORDER OF THE MATRIX.
C
C        LOW AND IGH ARE INTEGERS DETERMINED BY THE BALANCING
C          SUBROUTINE QTC031.  IF QTC031 HAS NOT BEEN USED,
C          SET LOW=1, IGH=N.
C
C        ORTR AND ORTI CONTAIN INFORMATION ABOUT THE UNITARY TRANS-
C          FORMATIONS USED IN THE REDUCTION BY QTC034, IF PERFORMED.
C          ONLY ELEMENTS LOW THROUGH IGH ARE USED.  IF THE EIGENVECTORS
C          OF THE HESSENBERG MATRIX ARE DESIRED, SET ORTR(J) AND
C          ORTI(J) TO 0.0 FOR THESE ELEMENTS.
C
C        HR AND HI CONTAIN THE REAL AND IMAGINARY PARTS,
C          RESPECTIVELY, OF THE COMPLEX UPPER HESSENBERG MATRIX.
C          THEIR LOWER TRIANGLES BELOW THE SUBDIAGONAL CONTAIN FURTHER
C          INFORMATION ABOUT THE TRANSFORMATIONS WHICH WERE USED IN THE
C          REDUCTION BY QTC034, IF PERFORMED.  IF THE EIGENVECTORS OF
C          THE HESSENBERG MATRIX ARE DESIRED, THESE ELEMENTS MAY BE
C          ARBITRARY.
C
C     ON OUTPUT
C
C        ORTR, ORTI, AND THE UPPER HESSENBERG PORTIONS OF HR AND HI
C          HAVE BEEN DESTROYED.
C
C        WR AND WI CONTAIN THE REAL AND IMAGINARY PARTS,
C          RESPECTIVELY, OF THE EIGENVALUES.  IF AN ERROR
C          EXIT IS MADE, THE EIGENVALUES SHOULD BE CORRECT
C          FOR INDICES IERR+1,...,N.
C
C        ZR AND ZI CONTAIN THE REAL AND IMAGINARY PARTS,
C          RESPECTIVELY, OF THE EIGENVECTORS.  THE EIGENVECTORS
C          ARE UNNORMALIZED.  IF AN ERROR EXIT IS MADE, NONE OF
C          THE EIGENVECTORS HAS BEEN FOUND.
C
C        IERR IS SET TO
C          ZERO       FOR NORMAL RETURN,
C          J          IF THE LIMIT OF 30*N ITERATIONS IS EXHAUSTED
C                     WHILE THE J-TH EIGENVALUE IS BEING SOUGHT.
C
C     CALLS QTC032 FOR COMPLEX DIVISION.
C     CALLS QTC035 FOR COMPLEX SQUARE ROOT.
C     CALLS QTC041 FOR  SQRT(A*A + B*B) .
C
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW,
C     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY
C
C     THIS VERSION DATED AUGUST 1983.
C
C     ------------------------------------------------------------------
C
      IERR = 0
C     .......... INITIALIZE EIGENVECTOR MATRIX ..........
      DO 101 J = 1, N
C
         DO 100 I = 1, N
            ZZ(1,I,J) = 0.0
            ZZ(2,I,J) = 0.0
  100    CONTINUE
         ZZ(1,J,J) = 1.0
  101 CONTINUE
C     .......... FORM THE MATRIX OF ACCUMULATED TRANSFORMATIONS
C                FROM THE INFORMATION LEFT BY QTC034 ..........
      IEND = IGH - LOW - 1
      IF (IEND) 180, 150, 105
C     .......... FOR I=IGH-1 STEP -1 UNTIL LOW+1 DO -- ..........
  105 DO 140 II = 1, IEND
         I = IGH - II
         IF (ORT(1,I) .EQ. 0.0 .AND. ORT(2,I) .EQ. 0.0) GO TO 140
         IF (HH(1,I,I-1).EQ.0.0 .AND. HH(2,I,I-1).EQ.0.0) GO TO 140
C     .......... NORM BELOW IS NEGATIVE OF H FORMED IN QTC034 ..........
         NORM = HH(1,I,I-1) * ORT(1,I) + HH(2,I,I-1) * ORT(2,I)
         IP1 = I + 1
C
         DO 110 K = IP1, IGH
            ORT(1,K) = HH(1,K,I-1)
            ORT(2,K) = HH(2,K,I-1)
  110    CONTINUE
C
         DO 130 J = I, IGH
            SR = 0.0
            SI = 0.0
C
            DO 115 K = I, IGH
               SR = SR + ORT(1,K) * ZZ(1,K,J) + ORT(2,K) * ZZ(2,K,J)
               SI = SI + ORT(1,K) * ZZ(2,K,J) - ORT(2,K) * ZZ(1,K,J)
  115       CONTINUE
C
            SR = SR / NORM
            SI = SI / NORM
C
            DO 120 K = I, IGH
               ZZ(1,K,J) = ZZ(1,K,J) + SR * ORT(1,K) - SI * ORT(2,K)
               ZZ(2,K,J) = ZZ(2,K,J) + SR * ORT(2,K) + SI * ORT(1,K)
  120       CONTINUE
C
  130    CONTINUE
C
  140 CONTINUE
C     .......... CREATE REAL SUBDIAGONAL ELEMENTS ..........
  150 L = LOW + 1
C
      DO 170 I = L, IGH
         LL = MIN0(I+1,IGH)
         IF (HH(2,I,I-1) .EQ. 0.0) GO TO 170
         NORM = QTC041(HH(1,I,I-1),HH(2,I,I-1))
         YR = HH(1,I,I-1) / NORM
         YI = HH(2,I,I-1) / NORM
         HH(1,I,I-1) = NORM
         HH(2,I,I-1) = 0.0
C
         DO 155 J = I, N
            SI = YR * HH(2,I,J) - YI * HH(1,I,J)
            HH(1,I,J) = YR * HH(1,I,J) + YI * HH(2,I,J)
            HH(2,I,J) = SI
  155    CONTINUE
C
         DO 160 J = 1, LL
            SI = YR * HH(2,J,I) + YI * HH(1,J,I)
            HH(1,J,I) = YR * HH(1,J,I) - YI * HH(2,J,I)
            HH(2,J,I) = SI
  160    CONTINUE
C
         DO 165 J = LOW, IGH
            SI = YR * ZZ(2,J,I) + YI * ZZ(1,J,I)
            ZZ(1,J,I) = YR * ZZ(1,J,I) - YI * ZZ(2,J,I)
            ZZ(2,J,I) = SI
  165    CONTINUE
C
  170 CONTINUE
C     .......... STORE ROOTS ISOLATED BY QTC031 ..........
  180 DO 200 I = 1, N
         IF (I .GE. LOW .AND. I .LE. IGH) GO TO 200
         WW(1,I) = HH(1,I,I)
         WW(2,I) = HH(2,I,I)
  200 CONTINUE
C
      EN = IGH
      TR = 0.0
      TI = 0.0
      ITN = 30*N
C     .......... SEARCH FOR NEXT EIGENVALUE ..........
  220 IF (EN .LT. LOW) GO TO 680
      ITS = 0
      ENM1 = EN - 1
C     .......... LOOK FOR SINGLE SMALL SUB-DIAGONAL ELEMENT
C                FOR L=EN STEP -1 UNTIL LOW DO -- ..........
  240 DO 260 LL = LOW, EN
         L = EN + LOW - LL
         IF (L .EQ. LOW) GO TO 300
         TST1 = ABS(HH(1,L-1,L-1)) + ABS(HH(2,L-1,L-1))
     X            + ABS(HH(1,L,L)) + ABS(HH(2,L,L))
         TST2 = TST1 + ABS(HH(1,L,L-1))
         IF (TST2 .EQ. TST1) GO TO 300
  260 CONTINUE
C     .......... FORM SHIFT ..........
  300 IF (L .EQ. EN) GO TO 660
      IF (ITN .EQ. 0) GO TO 1000
      IF (ITS .EQ. 10 .OR. ITS .EQ. 20) GO TO 320
      SR = HH(1,EN,EN)
      SI = HH(2,EN,EN)
      XR = HH(1,ENM1,EN) * HH(1,EN,ENM1)
      XI = HH(2,ENM1,EN) * HH(1,EN,ENM1)
      IF (XR .EQ. 0.0 .AND. XI .EQ. 0.0) GO TO 340
      YR = (HH(1,ENM1,ENM1) - SR) / 2.0
      YI = (HH(2,ENM1,ENM1) - SI) / 2.0
      CALL QTC035(YR**2-YI**2+XR,2.0*YR*YI+XI,ZZR,ZZI)
      IF (YR * ZZR + YI * ZZI .GE. 0.0) GO TO 310
      ZZR = -ZZR
      ZZI = -ZZI
  310 CALL QTC032(XR,XI,YR+ZZR,YI+ZZI,XR,XI)
      SR = SR - XR
      SI = SI - XI
      GO TO 340
C     .......... FORM EXCEPTIONAL SHIFT ..........
  320 SR = ABS(HH(1,EN,ENM1)) + ABS(HH(1,ENM1,EN-2))
      SI = 0.0
C
  340 DO 360 I = LOW, EN
         HH(1,I,I) = HH(1,I,I) - SR
         HH(2,I,I) = HH(2,I,I) - SI
  360 CONTINUE
C
      TR = TR + SR
      TI = TI + SI
      ITS = ITS + 1
      ITN = ITN - 1
C     .......... REDUCE TO TRIANGLE (ROWS) ..........
      LP1 = L + 1
C
      DO 500 I = LP1, EN
         SR = HH(1,I,I-1)
         HH(1,I,I-1) = 0.0
         NORM = QTC041(QTC041(HH(1,I-1,I-1),HH(2,I-1,I-1)),SR)
         XR = HH(1,I-1,I-1) / NORM
         WW(1,I-1) = XR
         XI = HH(2,I-1,I-1) / NORM
         WW(2,I-1) = XI
         HH(1,I-1,I-1) = NORM
         HH(2,I-1,I-1) = 0.0
         HH(2,I,I-1) = SR / NORM
C
         DO 490 J = I, N
            YR = HH(1,I-1,J)
            YI = HH(2,I-1,J)
            ZZR = HH(1,I,J)
            ZZI = HH(2,I,J)
            HH(1,I-1,J) = XR * YR + XI * YI + HH(2,I,I-1) * ZZR
            HH(2,I-1,J) = XR * YI - XI * YR + HH(2,I,I-1) * ZZI
            HH(1,I,J) = XR * ZZR - XI * ZZI - HH(2,I,I-1) * YR
            HH(2,I,J) = XR * ZZI + XI * ZZR - HH(2,I,I-1) * YI
  490    CONTINUE
C
  500 CONTINUE
C
      SI = HH(2,EN,EN)
      IF (SI .EQ. 0.0) GO TO 540
      NORM = QTC041(HH(1,EN,EN),SI)
      SR = HH(1,EN,EN) / NORM
      SI = SI / NORM
      HH(1,EN,EN) = NORM
      HH(2,EN,EN) = 0.0
      IF (EN .EQ. N) GO TO 540
      IP1 = EN + 1
C
      DO 520 J = IP1, N
         YR = HH(1,EN,J)
         YI = HH(2,EN,J)
         HH(1,EN,J) = SR * YR + SI * YI
         HH(2,EN,J) = SR * YI - SI * YR
  520 CONTINUE
C     .......... INVERSE OPERATION (COLUMNS) ..........
  540 DO 600 J = LP1, EN
         XR = WW(1,J-1)
         XI = WW(2,J-1)
C
         DO 580 I = 1, J
            YR = HH(1,I,J-1)
            YI = 0.0
            ZZR = HH(1,I,J)
            ZZI = HH(2,I,J)
            IF (I .EQ. J) GO TO 560
            YI = HH(2,I,J-1)
            HH(2,I,J-1) = XR * YI + XI * YR + HH(2,J,J-1) * ZZI
  560       HH(1,I,J-1) = XR * YR - XI * YI + HH(2,J,J-1) * ZZR
            HH(1,I,J) = XR * ZZR + XI * ZZI - HH(2,J,J-1) * YR
            HH(2,I,J) = XR * ZZI - XI * ZZR - HH(2,J,J-1) * YI
  580    CONTINUE
C
         DO 590 I = LOW, IGH
            YR = ZZ(1,I,J-1)
            YI = ZZ(2,I,J-1)
            ZZR = ZZ(1,I,J)
            ZZI = ZZ(2,I,J)
            ZZ(1,I,J-1) = XR * YR - XI * YI + HH(2,J,J-1) * ZZR
            ZZ(2,I,J-1) = XR * YI + XI * YR + HH(2,J,J-1) * ZZI
            ZZ(1,I,J) = XR * ZZR + XI * ZZI - HH(2,J,J-1) * YR
            ZZ(2,I,J) = XR * ZZI - XI * ZZR - HH(2,J,J-1) * YI
  590    CONTINUE
C
  600 CONTINUE
C
      IF (SI .EQ. 0.0) GO TO 240
C
      DO 630 I = 1, EN
         YR = HH(1,I,EN)
         YI = HH(2,I,EN)
         HH(1,I,EN) = SR * YR - SI * YI
         HH(2,I,EN) = SR * YI + SI * YR
  630 CONTINUE
C
      DO 640 I = LOW, IGH
         YR = ZZ(1,I,EN)
         YI = ZZ(2,I,EN)
         ZZ(1,I,EN) = SR * YR - SI * YI
         ZZ(2,I,EN) = SR * YI + SI * YR
  640 CONTINUE
C
      GO TO 240
C     .......... A ROOT FOUND ..........
  660 HH(1,EN,EN) = HH(1,EN,EN) + TR
      WW(1,EN) = HH(1,EN,EN)
      HH(2,EN,EN) = HH(2,EN,EN) + TI
      WW(2,EN) = HH(2,EN,EN)
      EN = ENM1
      GO TO 220
C     .......... ALL ROOTS FOUND.  BACKSUBSTITUTE TO FIND
C                VECTORS OF UPPER TRIANGULAR FORM ..........
  680 NORM = 0.0
C
      DO 720 I = 1, N
C
         DO 720 J = I, N
            TR = ABS(HH(1,I,J)) + ABS(HH(2,I,J))
            IF (TR .GT. NORM) NORM = TR
  720 CONTINUE
C
      IF (N .EQ. 1 .OR. NORM .EQ. 0.0) GO TO 1001
C     .......... FOR EN=N STEP -1 UNTIL 2 DO -- ..........
      DO 800 NN = 2, N
         EN = N + 2 - NN
         XR = WW(1,EN)
         XI = WW(2,EN)
         HH(1,EN,EN) = 1.0
         HH(2,EN,EN) = 0.0
         ENM1 = EN - 1
C     .......... FOR I=EN-1 STEP -1 UNTIL 1 DO -- ..........
         DO 780 II = 1, ENM1
            I = EN - II
            ZZR = 0.0
            ZZI = 0.0
            IP1 = I + 1
C
            DO 740 J = IP1, EN
               ZZR = ZZR + HH(1,I,J)*HH(1,J,EN) - HH(2,I,J)*HH(2,J,EN)
               ZZI = ZZI + HH(1,I,J)*HH(2,J,EN) + HH(2,I,J)*HH(1,J,EN)
  740       CONTINUE
C
            YR = XR - WW(1,I)
            YI = XI - WW(2,I)
            IF (YR .NE. 0.0 .OR. YI .NE. 0.0) GO TO 765
               TST1 = NORM
               YR = TST1
  760          YR = 0.01 * YR
               TST2 = NORM + YR
               IF (TST2 .GT. TST1) GO TO 760
  765       CONTINUE
            CALL QTC032(ZZR,ZZI,YR,YI,HH(1,I,EN),HH(2,I,EN))
C     .......... OVERFLOW CONTROL ..........
            TR = ABS(HH(1,I,EN)) + ABS(HH(2,I,EN))
            IF (TR .EQ. 0.0) GO TO 780
            TST1 = TR
            TST2 = TST1 + 1.0/TST1
            IF (TST2 .GT. TST1) GO TO 780
            DO 770 J = I, EN
               HH(1,J,EN) = HH(1,J,EN)/TR
               HH(2,J,EN) = HH(2,J,EN)/TR
  770       CONTINUE
C
  780    CONTINUE
C
  800 CONTINUE
C     .......... END BACKSUBSTITUTION ..........
      ENM1 = N - 1
C     .......... VECTORS OF ISOLATED ROOTS ..........
      DO  840 I = 1, ENM1
         IF (I .GE. LOW .AND. I .LE. IGH) GO TO 840
         IP1 = I + 1
C
         DO 820 J = IP1, N
            ZZ(1,I,J) = HH(1,I,J)
            ZZ(2,I,J) = HH(2,I,J)
  820    CONTINUE
C
  840 CONTINUE
C     .......... MULTIPLY BY TRANSFORMATION MATRIX TO GIVE
C                VECTORS OF ORIGINAL FULL MATRIX.
C                FOR J=N STEP -1 UNTIL LOW+1 DO -- ..........
      DO 880 JJ = LOW, ENM1
         J = N + LOW - JJ
         M = MIN0(J,IGH)
C
         DO 880 I = LOW, IGH
            ZZR = 0.0
            ZZI = 0.0
C
            DO 860 K = LOW, M
               ZZR = ZZR + ZZ(1,I,K) * HH(1,K,J) - ZZ(2,I,K) * HH(2,K,J)
               ZZI = ZZI + ZZ(1,I,K) * HH(2,K,J) + ZZ(2,I,K) * HH(1,K,J)
  860       CONTINUE
C
            ZZ(1,I,J) = ZZR
            ZZ(2,I,J) = ZZI
  880 CONTINUE
C
      GO TO 1001
C     .......... SET ERROR -- ALL EIGENVALUES HAVE NOT
C                CONVERGED AFTER 30*N ITERATIONS ..........
 1000 IERR = EN
 1001 RETURN
      END
