C*****  QTC034  MATH ADVANTAGE Private Subroutine CORTH
C       (EISPACK , August 1983 Version)
C
C  MODIFICATIONS to Standard EISPACK
C
C         o Store complex data as adjacent real/imaginary pairs, instead
C           of using one array for real components and a different array
C           for imaginary components.  This was implemented by, for
C           example, replacing the declarations AR(NM,N) and AI(NM,N)
C           with the declaration AA(2,NM,N).  All subsequent references
C           to AR(i,j) are replaced with AA(1,i,j), and all references
C           to AI(i,j) are replaced with AA(2,i,j).  The related change
C           is also made in the subroutine parameter list.
C
C  HISTORY
C         1) Sep 86     L. Tarvestad    Original.
C
      SUBROUTINE QTC034(NM,N,LOW,IGH,AA,ORT)
C
      INTEGER I,J,M,N,II,JJ,LA,MP,NM,IGH,KP1,LOW
      REAL AA(2,NM,N),ORT(2,IGH)
      REAL F,G,H,FI,FR,SCALE,QTC041
C
C     THIS SUBROUTINE IS A TRANSLATION OF A COMPLEX ANALOGUE OF
C     THE ALGOL PROCEDURE ORTHES, NUM. MATH. 12, 349-368(1968)
C     BY MARTIN AND WILKINSON.
C     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 339-358(1971).
C
C     GIVEN A COMPLEX GENERAL MATRIX, THIS SUBROUTINE
C     REDUCES A SUBMATRIX SITUATED IN ROWS AND COLUMNS
C     LOW THROUGH IGH TO UPPER HESSENBERG FORM BY
C     UNITARY SIMILARITY TRANSFORMATIONS.
C
C     ON INPUT
C
C        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL
C          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
C          DIMENSION STATEMENT.
C
C        N IS THE ORDER OF THE MATRIX.
C
C        LOW AND IGH ARE INTEGERS DETERMINED BY THE BALANCING
C          SUBROUTINE QTC031.  IF QTC031 HAS NOT BEEN USED,
C          SET LOW=1, IGH=N.
C
C        AR AND AI CONTAIN THE REAL AND IMAGINARY PARTS,
C          RESPECTIVELY, OF THE COMPLEX INPUT MATRIX.
C
C     ON OUTPUT
C
C        AR AND AI CONTAIN THE REAL AND IMAGINARY PARTS,
C          RESPECTIVELY, OF THE HESSENBERG MATRIX.  INFORMATION
C          ABOUT THE UNITARY TRANSFORMATIONS USED IN THE REDUCTION
C          IS STORED IN THE REMAINING TRIANGLES UNDER THE
C          HESSENBERG MATRIX.
C
C        ORTR AND ORTI CONTAIN FURTHER INFORMATION ABOUT THE
C          TRANSFORMATIONS.  ONLY ELEMENTS LOW THROUGH IGH ARE USED.
C
C     CALLS QTC041 FOR  SQRT(A*A + B*B) .
C
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW,
C     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY
C
C     THIS VERSION DATED AUGUST 1983.
C
C     ------------------------------------------------------------------
C
      LA = IGH - 1
      KP1 = LOW + 1
      IF (LA .LT. KP1) GO TO 200
C
      DO 180 M = KP1, LA
         H = 0.0
         ORT(1,M) = 0.0
         ORT(2,M) = 0.0
         SCALE = 0.0
C     .......... SCALE COLUMN (ALGOL TOL THEN NOT NEEDED) ..........
         DO 90 I = M, IGH
   90    SCALE = SCALE + ABS(AA(1,I,M-1)) + ABS(AA(2,I,M-1))
C
         IF (SCALE .EQ. 0.0) GO TO 180
         MP = M + IGH
C     .......... FOR I=IGH STEP -1 UNTIL M DO -- ..........
         DO 100 II = M, IGH
            I = MP - II
            ORT(1,I) = AA(1,I,M-1) / SCALE
            ORT(2,I) = AA(2,I,M-1) / SCALE
            H = H + ORT(1,I) * ORT(1,I) + ORT(2,I) * ORT(2,I)
  100    CONTINUE
C
         G = SQRT(H)
         F = QTC041(ORT(1,M),ORT(2,M))
         IF (F .EQ. 0.0) GO TO 103
         H = H + F * G
         G = G / F
         ORT(1,M) = (1.0 + G) * ORT(1,M)
         ORT(2,M) = (1.0 + G) * ORT(2,M)
         GO TO 105
C
  103    ORT(1,M) = G
         AA(1,M,M-1) = SCALE
C     .......... FORM (I-(U*UT)/H) * A ..........
  105    DO 130 J = M, N
            FR = 0.0
            FI = 0.0
C     .......... FOR I=IGH STEP -1 UNTIL M DO -- ..........
            DO 110 II = M, IGH
               I = MP - II
               FR = FR + ORT(1,I) * AA(1,I,J) + ORT(2,I) * AA(2,I,J)
               FI = FI + ORT(1,I) * AA(2,I,J) - ORT(2,I) * AA(1,I,J)
  110       CONTINUE
C
            FR = FR / H
            FI = FI / H
C
            DO 120 I = M, IGH
               AA(1,I,J) = AA(1,I,J) - FR * ORT(1,I) + FI * ORT(2,I)
               AA(2,I,J) = AA(2,I,J) - FR * ORT(2,I) - FI * ORT(1,I)
  120       CONTINUE
C
  130    CONTINUE
C     .......... FORM (I-(U*UT)/H)*A*(I-(U*UT)/H) ..........
         DO 160 I = 1, IGH
            FR = 0.0
            FI = 0.0
C     .......... FOR J=IGH STEP -1 UNTIL M DO -- ..........
            DO 140 JJ = M, IGH
               J = MP - JJ
               FR = FR + ORT(1,J) * AA(1,I,J) - ORT(2,J) * AA(2,I,J)
               FI = FI + ORT(1,J) * AA(2,I,J) + ORT(2,J) * AA(1,I,J)
  140       CONTINUE
C
            FR = FR / H
            FI = FI / H
C
            DO 150 J = M, IGH
               AA(1,I,J) = AA(1,I,J) - FR * ORT(1,J) - FI * ORT(2,J)
               AA(2,I,J) = AA(2,I,J) + FR * ORT(2,J) - FI * ORT(1,J)
  150       CONTINUE
C
  160    CONTINUE
C
         ORT(1,M) = SCALE * ORT(1,M)
         ORT(2,M) = SCALE * ORT(2,M)
         AA(1,M,M-1) = -G * AA(1,M,M-1)
         AA(2,M,M-1) = -G * AA(2,M,M-1)
  180 CONTINUE
C
  200 RETURN
      END
