C***** QTC060  BUILD FULL ADJACENCY STRUCTURE  REV 1.0         JAN 88
C
C  PURPOSE:
C       BUILDS THE ADJACENCY STRUCTURE FOR A GRAPH GIVEN A LIST OF
C       EDGES.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC060 (II, JJ, IADJ, JADJ, IWRK, M, N, NE, MAX, IERR)
C
C  PARAMETERS:
C       II      INTEGER INPUT VECTOR OF LENGTH M
C               CONTAINS A LIST OF NODES THAT ARE ONE END OF AN EDGE.
C               FOR THE GRAPH OF A MATRIX, II IS A LIST OF ROW NUMBERS
C               OF THE NONZERO ELEMENTS.
C
C       JJ      INTEGER INPUT VECTOR OF LENGTH M
C               CONTAINS A LIST OF NODES THAT ARE THE OTHER END OF THE
C               EDGE FROM THE CORRESPONDING NODE IN II. FOR THE GRAPH OF
C               A MATRIX, JJ IS A LIST OF COLUMN NUMBERS OF THE
C               NONZERO ELEMENTS.
C
C       IADJ    INTEGER OUTPUT VECTOR OF LENGTH N+1
C               POINTERS INTO THE ADJACENCY VECTOR.  IADJ(N+1) = 2*NE+1.
C
C       JADJ    INTEGER OUTPUT VECTOR OF LENGTH MAX
C               THE ADJACENCY STRUCTURE OF THE GRAPH IS STORED IN THE
C               FIRST 2*NE ELEMENTS ON OUTPUT.
C
C       IWRK    INTEGER SCRATCH VECTOR OF LENGTH N
C
C       M       INTEGER INPUT SCALAR
C               ELEMENT COUNT FOR II AND JJ.
C
C       N       INTEGER INPUT SCALAR
C               NUMBER OF NODES IN THE GRAPH.  FOR THE GRAPH OF A
C               MATRIX, THIS IS THE ORDER OF THE MATRIX.
C
C       NE      INTEGER OUTPUT SCALAR
C               NUMBERS OF EDGES IN THE GRAPH.
C
C       MAX     INTEGER INPUT SCALAR
C               NUMBERS OF WORDS AVAILABLE IN THE ARRAY JADJ.  MAX MUST
C               BE >= 2*NE+1.
C
C       IERR    INTEGER OUTPUT SCALAR
C               COMPLETION CODE: IERR = 0 - NORMAL COMPLETION
C                                IERR = 1 - INVALID NODE NUMBER
C                                IERR = 2 - INSUFFICIENT SPACE IN JADJ
C
C  DESCRIPTION:
C       BUILDS THE FULL ADJACENCY STRUCTURE FOR A GRAPH GIVEN A LIST OF
C       EDGES WHERE JADJ(J) FOR IADJ(I) <= J < IADJ(I+1) IS THE LIST OF
C       NODES ADJACENT TO NODE I.  THE LIST OF EDGES IS DEFINED BY THE
C       ARRAY PAIR (II,JJ) WHERE THE PAIR (II(K),JJ(K)) REPRESENTS AN
C       EDGE CONNECTING NODE II(K) AND NODE JJ(K).  NOTE THAT THE PAIRS
C       (K,L) AND (L,K) DEFINE THE SAME EDGE.  REDUNDANT EDGES IN THE
C       LIST ARE IGNORED.  LIKEWISE, PAIRS THAT HAVE EQUAL NODES (II(K)
C       = JJ(K)) DO NOT DEFINE AN EDGE AND ARE IGNORED.  THUS, THE
C       NUMBER OF EDGES, NE, WILL ALWAYS BE LESS THAN OR EQUAL TO M.
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       QTC061, QTC063, QTC065
C
C  ERROR CONDITIONS:
C       IF A NODE NUMBER IS INVALID (<0 OR >N) OR IF THERE IS
C       INSUFFICIENT SPACE IN JADJ FOR THE ADJACENCY STRUCTURE, THEN
C       THE APPROPRIATE ERROR CODE IS SET AND THE ROUTINE IS ABORTED.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC060 (II, JJ, IADJ, JADJ, IWRK, M, N, NE, MAX,
     &                   IERR)
C
      INTEGER II(1), JJ(1), IADJ(1), JADJ(1), IWRK(1), M, N, NE,
     &        MAX, IERR
C
C-----------------------------------------------------------------------
C
C     -----------------------------------------------------------
C     CALL QTC061 TO BUILD LINKED LIST LOWER ADJACENCY STRUCTURE.
C     IWRK WILL CONTAIN POINTERS TO THE HEAD OF THE LISTS.
C     IADJ WILL CONTAIN POINTERS TO THE TAIL OF THE LISTS.
C     JADJ WILL CONTAIN THE LINKED LISTS.
C     -----------------------------------------------------------
C
      CALL QTC061 (II, JJ, IWRK, IADJ, JADJ, M, N, NE, MAX, IERR)
C
C     ----------------
C     CHECK FOR ERRORS
C     ----------------
C
      IF (MAX .LE. 2*NE) IERR = 2
      IF (IERR .NE. 0) GO TO 800
C
C     ---------------------------------------------------
C     CALL QTC063 TO BUILD THE LOWER ADJACENCY STRUCTURED
C     IN IADJ AND JADJ FROM THE LINKED LISTS.
C     ---------------------------------------------------
C
      CALL QTC063 (IWRK, IADJ, JADJ, N, NE, MAX)
C
C     --------------------------------------------------
C     CALL QTC065 TO BUILD THE FULL ADJACENCY STRUCTURED
C     --------------------------------------------------
C
      CALL QTC065 (IADJ, JADJ, IWRK, N, NE)
C
C     ------------
C     EXIT ROUTINE
C     ------------
C
  800 CONTINUE
      RETURN
      END
