C***** QTC064  COMPRESS LINKED LIST            REV 1.0         JAN 88
C
C  PURPOSE:
C       COMPRESSES THE LINKED LIST TO REMOVE UNUSED ENTRIES.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC064 (IHEAD, LLIST, N, NE, MAX, MARKER)
C
C  PARAMETERS:
C       IHEAD   INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               POINTERS TO THE HEAD OF THE LIST FOR EACH NODE.
C
C       LLIST   INTEGER INPUT/OUTPUT VECTOR OF LENGTH MAX
C               CONTAINS THE LINKED LISTS IN THE LAST 2*NE ELEMENTS.
C
C       N       INTEGER INPUT SCALAR
C               NUMBER OF NODES IN THE GRAPH.
C
C       NE      INTEGER INPUT/OUTPUT SCALAR
C               NUMBERS OF ENTRIES (EDGES) IN THE LINKED LIST.
C
C       MAX     INTEGER INPUT SCALAR
C               ELEMENT COUNT FOR LLIST.
C
C       MARKER  INTEGER INPUT SCALAR
C               VALUE USED TO MARK UNUSED ENTRIES IN LINKED LIST.
C
C  DESCRIPTION:
C       ON INPUT, THE LINKED LIST IS STORED IN THE LAST 2*NE ELEMENTS
C       OF THE ARRAY LLIST.  THIS SPACE INCLUDES UNUSED ENTRIES THAT
C       CONTAIN THE VALUE OF MARKER IN BOTH THE VALUE AND LINK FIELDS.
C       THIS ROUTINE COMPRESSES THE LIST TO REMOVE ALL UNUSED ENTRIES.
C       THE PARAMETERS NE, IHEAD, AND LLIST ARE UPDATED.  ON OUTPUT,
C       THE COMPRESSED LINKED LIST IS STORED IN THE LAST 2*NE ELEMENTS
C       OF LLIST WHERE NE IS THE UPDATED ENTRY COUNT.
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC064 (IHEAD, LLIST, N, NE, MAX, MARKER)
C
      INTEGER IHEAD(1), LLIST(1), N, NE, MAX, MARKER
      INTEGER I, IBOT, ICUT, ITOP, J, K, M
C
C-----------------------------------------------------------------------
C
      IBOT = MAX - 2 * NE + 1
      ITOP = MAX - 1
C
      M    = 0
      DO 110 I = IBOT, ITOP, 2
         IF (LLIST(I) .EQ. MARKER) M = M + 1
  110 CONTINUE
      IF (M .EQ. 0) GO TO 800
C
      NE   = NE - M
      ICUT = MAX - 2 * NE - 1
C
      DO 120 I = IBOT, ICUT, 2
         IF (LLIST(I) .EQ. MARKER) M = M - 1
  120 CONTINUE
      IF (M .EQ. 0) GO TO 800
C
      J    = MAX + 1
      DO 220 K = 1, N
         I = IHEAD(K)
         IF (I .GT. 0 .AND. I .LE. ICUT) THEN
  210       CONTINUE
               J = J - 2
               IF (LLIST(J) .NE. MARKER) GO TO 210
C
            LLIST(J  ) = LLIST(I  )
            LLIST(J+1) = LLIST(I+1)
            LLIST(I+1) = 0
            IHEAD(K)   = J
            M          = M - 1
            IF (M .EQ. 0) GO TO 800
         ENDIF
  220 CONTINUE
C
  300 CONTINUE
      DO 320 K = IBOT, ITOP, 2
         I = LLIST(K+1)
         IF (I .GT. 0 .AND. I .LE. ICUT) THEN
  310       CONTINUE
               J = J - 2
               IF (LLIST(J) .NE. MARKER) GO TO 310
C
            LLIST(J  ) = LLIST(I  )
            LLIST(J+1) = LLIST(I+1)
            LLIST(I+1) = 0
            LLIST(K+1) = J
            M          = M - 1
            IF (M .EQ. 0) GO TO 800
         ENDIF
  320 CONTINUE
      GO TO 300
C
  800 CONTINUE
      RETURN
      END
