C***** QTC067  FIND PSEUDO-PERIPHERAL NODE     REV 1.0         JAN 88
C
C  PURPOSE:
C       FINDS THE PSEUDO-PERIPHERAL NODE
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          THOMAS COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC067 (IROOT, IADJ, JADJ, MASK, NLVLS, ILS, JLS)
C
C  PARAMETERS:
C       IROOT   INTERER INPUT/OUTPUT SCALAR
C               ON INPUT, IT DEFINES THE COMPONENT FOR WHICH
C               A PSEUDO-PERIPHERAL NODE IS TO BE FOUND. ON
C               OUTPUT, IT IS THE NODE OBTAINED.
C
C       IADJ    INTEGER INPUT VECTOR OF LENGTH N+1
C               CONTAINS POINTERS INTO THE ADJACENCY VECTOR, JADJ.
C               IADJ(N+1) = 2*NE+1, WHERE NE IS THE NUMBER OF EDGES.
C
C       JADJ    INTEGER INPUT VECTOR OF LENGTH 2*NE
C               CONTAINS THE ADJACENCY STRUCTURE OF THE GRAPH.
C
C       MASK    INTEGER INPUT VECTOR OF LENGTH N
C               SPECIFIES THE SECTION SUBGRAPH.  NODES FOR WHICH
C               MASK IS ZERO ARE IGNORED BY THIS SUBROUTINE
C
C       NLVLS   INTEGER OUTPUT SCALAR
C               THE NUMBER OF LEVELS IN THE LEVEL STRUCTURE ROOTED
C               AT THE NODE IROOT
C
C       ILS     INTEGER OUTPUT VECTOR
C               POINTERS INTO JLS
C
C       JLS     INTEGER OUTPUT VECTOR
C               THE LEVEL STRUCTURE
C
C  DESCRIPTION:
C       THIS SUBROUTINE FINDS THE PSEUDO-PERIPHERAL NODE OF A CONNECTED
C       COMPONENT OF A GIVEN GRAPH.  IF THE COMPONENT OF A SINGLE NODE
C       OR A CHAIN WITH IROOT AS ITS ENDPOINT,  THEN IROOT IS A PERIPHERAL
C       NODE AND JLS CONTAINS THE LEVEL STRUCTURE, SO EXECUTION TERMINATES.
C       OTHERWISE, A NODE OF MINIMUM DEGREE IN THE LAST LEVEL IS FOUND.
C       THE NEW LEVEL STRUCTURE ROOTED AT THIS NODE IS GENERATED (THE
C       SECOND CALL TO QTC068) AND THE TERMINATION TEST IS PERFORMED.
C       IF THE TEST FAILS CONTROL TRANSFERS TO STATEMENT 100 AND THE
C       PRECEDURE IS REPEATED.  ON EXIT, IROOT IS THE NODE NUMBER OF THE
C       PSEUDO-PERIPHERAL NODE, AND THE ARRAY PAIR (ILS, JLS) CONTAINS
C       THE CORRESPONDING ROOTED STRUCTURE.
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       QTCO68
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC067 (IROOT, IADJ, JADJ, MASK, NLVLS, ILS, JLS)
C
      INTEGER IROOT, IADJ(1), JADJ(1), MASK(1), NLVLS, ILS(1), JLS(1),
     &        ICCSIZ, J, JSTRT, K, KSTOP, KSTRT, MINDEG, NABOR, NDEG,
     &        NODE, NUNLVL
C
C-----------------------------------------------------------------------
C
C     ----------------------------------------------
C     DETERMINE THE LEVEL STRUCTURE ROOTED AT IROOT.
C     ----------------------------------------------
C
      CALL QTC068 (IROOT, IADJ, JADJ, MASK, NLVLS, ILS, JLS)
      ICCSIZ = ILS(NLVLS+1) - 1
C
      IF (NLVLS .EQ. 1 .OR. NLVLS .EQ. ICCSIZ) GOTO 800
C
C     ---------------------------------------------------
C     PICK A NODE WITH MINIMUM DEGREE FROM THE LAST LEVEL
C     ---------------------------------------------------
C
  100 CONTINUE
      JSTRT  = ILS(NLVLS)
      MINDEG = ICCSIZ
      IROOT  = JLS(JSTRT)
      IF ( ICCSIZ .NE. JSTRT ) THEN
         DO 120 J = JSTRT, ICCSIZ
            NODE  = JLS(J)
            NDEG  = 0
C
            KSTRT = IADJ(NODE)
            KSTOP = IADJ(NODE+1)-1
            DO 110 K = KSTRT, KSTOP
               NABOR = JADJ(K)
               IF (MASK(NABOR) .GT. 0) NDEG = NDEG + 1
  110       CONTINUE
C
            IF (NDEG .LT. MINDEG) THEN
               IROOT  = NODE
               MINDEG = NDEG
            ENDIF
  120    CONTINUE
      ENDIF
C
C     ----------------------------------------
C     AND GENERATE ITS ROOTED LEVEL STRUCTURE.
C     ----------------------------------------
C
      CALL QTC068 ( IROOT, IADJ, JADJ, MASK, NUNLVL, ILS, JLS )
C
      IF (NUNLVL .GT. NLVLS) THEN
         NLVLS = NUNLVL
         IF (NLVLS .LT. ICCSIZ) GO TO 100
      ENDIF
C
  800 CONTINUE
      RETURN
      END
