C***** QTC070  DEGREE IN MASKED COMPONENT      REV 1.0         JAN 88
C
C  PURPOSE:
C       COMPUTES THE DEGREES OF THE NODES IN THE CONNECTED COMPONENT
C       SPECIFIED BY MASK AND IROOT.  NODES FOR WHICH MASK IS ZERO
C       ARE IGNORED.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          THOMAS COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC070 (IROOT, IADJ, JADJ, MASK, IDGREE, ICCSIZ, LS)
C
C  PARAMETERS:
C       IROOT   INTEGER INPUT SCALAR
C               THE INPUT NODE THAT DEFINES THE COMPONENT.
C
C       IADJ    INTEGER INPUT VECTOR OF LENGTH N+1
C               CONTAINS POINTERS INTO THE ADJACENCY VECTOR, JADJ.
C               IADJ(N+1) = 2*NE+1, WHERE NE IS THE NUMBER OF EDGES.
C
C       JADJ    INTEGER INPUT VECTOR OF LENGTH 2*NE
C               CONTAINS THE ADJACENCY STRUCTURE OF THE GRAPH.
C
C       MASK    INTEGER INPUT VECTOR OF LENGTH N
C               SPECIFIES A SECTION SUBGRAPH.
C
C       IDGREE  INTEGER INPUT VECTOR OF LENGTH N
C               ARRAY CONTAINING THE DEGREES OF THE NODES IN THE COMPONENT.
C
C       ICCSIZ  INTEGER OUTPUT SCALAR
C               THE SIZE OF THE COMPONENT SPECIFIED BY MASK AND IROOT.
C
C       LS      INTEGER SCRATCH VECTOR OF LENGTH N
C               A TEMPORARY VECTOR USED TO STORE THE NODES OF THE
C               COMPONENTS LEVEL BY LEVEL.
C
C  DESCRIPTION:
C       THIS SUBROUTINE COMPUTES THE DEGREES OF THE NODES IN A CONNECTED
C       COMPONENT OF A GRAPH.  THE SUBROUTINE OPERATES ON THE CONNECTED
C       COMPONENT SPECIFIED BY THE INPUT PARAMETERS IROOT, MASK, IADJ,
C       AND JADJ.
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC070 (IROOT, IADJ, JADJ, MASK, IDGREE, ICCSIZ, LS)
C
      INTEGER IROOT, IADJ(1), JADJ(1), MASK(1), IDGREE(1), ICCSIZ,
     &        LS(1), I, J, JSTOP, JSTRT, LVLBEG, LVLEND, LVLSIZ, NBR,
     &        NDEG, NODE
C
C-----------------------------------------------------------------------
C
C     -------------------------------------------------
C     INITIALIZATION---
C     THE ARRAY IADJ IS USED AS A TEMPORARY TO
C     INDICATE WHICH NODES HAVE BEEN CONSIDERED SO FAR
C     -------------------------------------------------
C
      LS(1)       = IROOT
      IADJ(IROOT) = -IADJ(IROOT)
      LVLEND      = 0
      ICCSIZ      = 1
C
C     ------------------------------------------------------
C     LVLBEG IS THE POINTER TO THE BEGINNING OF THE CURRENT
C     LEVEL, AND LVLEND POINTS TO THE END OF THIS LEVEL.
C     ------------------------------------------------------
C
  100 CONTINUE
      LVLBEG = LVLEND + 1
      LVLEND = ICCSIZ
C
C     -----------------------------------------------
C     FIND THE DEGREES OF NODES IN THE CURRENT LEVEL.
C     AND AT THE SAME TIME, GENERATE THE NEXT LEVEL
C     -----------------------------------------------
C
      DO 130 I = LVLBEG, LVLEND
         NODE  = LS(I)
         JSTRT = -IADJ(NODE)
         JSTOP = IABS(IADJ(NODE+1)) - 1
         NDEG  = 0
C
         IF (JSTOP .GE. JSTRT) THEN
            DO 120 J = JSTRT, JSTOP
               NBR = JADJ(J)
C
               IF (MASK(NBR) .NE. 0) THEN
                  NDEG = NDEG + 1
C
                  IF (IADJ(NBR) .GE. 0) THEN
                     IADJ(NBR) = -IADJ(NBR)
                     ICCSIZ = ICCSIZ + 1
                     LS(ICCSIZ) = NBR
                  ENDIF
               ENDIF
  120       CONTINUE
         ENDIF
C
         IDGREE(NODE) = NDEG
  130 CONTINUE
C
C     ------------------------------------------
C     COMPUTE THE CURRENT WIDTH.
C     IF IT IS NONZERO, GENERATE ANOTHER LEVEL.
C     ------------------------------------------
C
      LVLSIZ = ICCSIZ - LVLEND
      IF (LVLSIZ .GT. 0) GO TO 100
C
C     ------------------------------------------
C     RESET IADJ TO ITS CORRECT SIGN AND RETURN
C     ------------------------------------------
C
      DO 210 I = 1, ICCSIZ
         NODE = LS(I)
         IADJ(NODE) = -IADJ(NODE)
  210 CONTINUE
C
      RETURN
      END
