C***** QTC073  MINIMUM DEGREE MERGE            REV 1.0         JAN 88
C
C  PURPOSE:
C       MERGES INDISTIGUISHABLE NODES AND ALSO COMPUTES THE NEW DEGREES
C       OF THE NEW SUPERNODES.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          THOMAS COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC073 (IADJ, JADJ, IDGREE, IQSIZE, IQLINK, MARKER, IDEG0,
C                    NHDSZE, NBRHD, IRCHST, IOVRLP)
C
C  PARAMETERS:
C       IADJ    INTEGER INPUT VECTOR OF LENGTH N+1
C               CONTAINS POINTERS INTO THE ADJACENCY VECTOR, JADJ.
C               IADJ(N+1) = 2*NE+1, WHERE NE IS THE NUMBER OF EDGES.
C
C       JADJ    INTEGER INPUT VECTOR OF LENGTH 2*NE
C               CONTAINS THE ADJACENCY STRUCTURE OF THE GRAPH.
C
C       IDGREE  INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               THE DEGREE VECTOR.
C
C       IQSIZE  INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               SIZE OF INDISTIGUISHABLE NODES.
C
C       IQLINK  INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               LINKED LIST FOR INDISTIGUISHABLE NODES.
C
C       MARKER  INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               THE GIVEN SET IS GIVEN BY THOSE NODES WITH MARKER
C               VALUE SET TO ONE.  THOSE NODES WITH DEGREE UPDATED
C               WILL HAVE MARKER SET TO TWO.
C
C       IDEG0   INTEGER INPUT SCALAR
C               THE NUMBER OF NODES IN THE GIVEN SET
C
C       NHDSZ   INTEGER INPUT SCALAR.
C
C       NBRHD   INTEGER INPUT VECTOR OF LENGTH N
C               THE SET OF ELIMINATED SUPERNODES ADJACENT TO SOME NODES
C               IN THE SET.
C
C       IRCHST  INTEGER SCRATCH VECTOR OF LENGTH N
C               THE VECTOR USED FOR THE REACHABLE SET.
C
C       IOVRLP  INTEGER SCRATCH VECTOR OF LENGTH N
C               USED TO STORE THE INTERSECTION OF TWO REACHABLE SETS.
C
C  DESCRIPTION:
C
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC073 (IADJ, JADJ, IDGREE, IQSIZE, IQLINK, MARKER,
     &                   IDEG0, NHDSZE, NBRHD, IRCHST, IOVRLP)
C
      INTEGER IADJ(1), JADJ(1), IDGREE(1), IQSIZE(1), IQLINK(1),
     &        MARKER(1), IDEG0, NHDSZE, NBRHD(1), IRCHST(1), IOVRLP(1),
     &        IDEG1, IHEAD, INHD, IOV, IRCH, IRCHSZ, IROOT, J, JSTRT,
     &        JSTOP, LINK, LNODE, MARK, MRGSZE, NABOR, NODE, NOVRLP
C
C-----------------------------------------------------------------------
C
C     --------------
C     INITIALIZATION
C     --------------
C
      IF (NHDSZE .LE. 0) GO TO 800
C
      DO 110 INHD = 1, NHDSZE
         IROOT = NBRHD(INHD)
         MARKER(IROOT) = 0
  110 CONTINUE
C
C     -------------------------------------------------
C     LOOP THROUGH EACH ELIMINATED SUPERNODE IN THE SET
C     (NHDSZE, NBRHD)
C     -------------------------------------------------
C
      DO 280 INHD = 1, NHDSZE
         IROOT = NBRHD(INHD)
         MARKER(IROOT) = - 1
         IRCHSZ = 0
         NOVRLP = 0
         IDEG1  = 0
C
C        ------------------------------------------------
C        DETERMINE THE REACHABLE SET AND ITS INTERSECTION
C        WITH THE INPUT REACHABLE SET.
C        ------------------------------------------------
C
  210    CONTINUE
         JSTRT  = IADJ(IROOT)
         JSTOP  = IADJ(IROOT+1) - 1
         DO 220 J = JSTRT, JSTOP
            NABOR = JADJ(J)
            IROOT = - NABOR
            IF (NABOR .GT. 0) THEN
               MARK = MARKER(NABOR)
               IF      (MARK .EQ. 1) THEN
                  NOVRLP = NOVRLP + 1
                  IOVRLP(NOVRLP) = NABOR
                  MARKER(NABOR) = 2
               ELSE IF (MARK .EQ. 0) THEN
                  IRCHSZ = IRCHSZ + 1
                  IRCHST(IRCHSZ) = NABOR
                  IDEG1 = IDEG1 + IQSIZE(NABOR)
                  MARKER(NABOR) = 1
               ENDIF
            ELSE IF (NABOR .LT. 0) THEN
               GO TO 210
            ELSE
               GO TO 230
            ENDIF
  220    CONTINUE
  230    CONTINUE
C
C        --------------------------------------------
C        FROM THE OVERLAPPED SET, DETERMINE THE NODES
C        THAT CAN BE MERGED TOGETHER.
C        --------------------------------------------
C
         IHEAD  = 0
         MRGSZE = 0
         DO 260 IOV = 1, NOVRLP
            NODE  = IOVRLP(IOV)
            JSTRT = IADJ(NODE)
            JSTOP = IADJ(NODE+1) -1
            DO 240 J = JSTRT, JSTOP
               NABOR = JADJ(J)
               IF (MARKER(NABOR) .EQ. 0) THEN
                  MARKER(NODE) = 1
                  GO TO 260
               ENDIF
  240       CONTINUE
C
C           -----------------------------------------
C           NODE BELONGS TO THE NEW MERGED SUPERNODE.
C           UPDATE THE VECTORS IQLINK AND IQSIZE.
C           -----------------------------------------
C
            MRGSZE = MRGSZE + IQSIZE(NODE)
            MARKER(NODE) = -1
            LNODE = NODE
C
  250       CONTINUE
            LINK = IQLINK(LNODE)
            IF (LINK .GT. 0) THEN
               LNODE = LINK
               GO TO 250
            ENDIF
C
            IQLINK(LNODE) = IHEAD
            IHEAD = NODE
  260    CONTINUE
C
         IF (IHEAD .GT. 0) THEN
            IQSIZE(IHEAD) = MRGSZE
            IDGREE(IHEAD) = IDEG0 + IDEG1 - 1
            MARKER(IHEAD) = 2
         ENDIF
C
C        -------------------
C        RESET MARKER VALUES
C        -------------------
C
         IROOT = NBRHD(INHD)
         MARKER(IROOT) = 0
C
         IF (IRCHSZ .GT. 0) THEN
            DO 270 IRCH = 1, IRCHSZ
               NODE = IRCHST(IRCH)
               MARKER(NODE) = 0
  270       CONTINUE
         ENDIF
  280 CONTINUE
C
  800 CONTINUE
      RETURN
      END
