C***** QTC074  MINIMUM DEGREE REACH SET        REV 1.0         JAN 88
C
C  PURPOSE:
C       DETERMINES THE REACHABLE SET OF A NODE THROUGH A GIVEN SUBSET.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          THOMAS COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC074 (IROOT, IADJ, JADJ, IDGREE, MARKER, IRCHSZ, IRCHST,
C                    NHDSZE, NBRHD)
C
C  PARAMETERS:
C       IROOT   INTEGER INPUT SCALAR
C               THE GIVEN NODE NOT IN THE SUBSET.
C
C       IADJ    INTEGER INPUT VECTOR OF LENGTH N+1
C               CONTAINS POINTERS INTO THE ADJACENCY VECTOR, JADJ.
C               IADJ(N+1) = 2*NE+1, WHERE NE IS THE NUMBER OF EDGES.
C
C       JADJ    INTEGER INPUT VECTOR OF LENGTH 2*NE
C               CONTAINS THE ADJACENCY STRUCTURE OF THE GRAPH.
C
C       IDGREE  INTEGER INPUT VECTOR OF LENGTH N
C               THE DEGREE VECTOR.  IDGREE(I) < 0, IF NODE I IS IN THE
C               GIVEN SUBSET.
C
C       MARKER  INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               MARKER VECTOR FOR REACH AND NBRHD SETS.
C               MARK(I) > 0 - NODE I IS IN REACH SET
C                       < 0 - NODE I IS IN NBRHD SET OR IT HAS BEEN
C                             MERGED WITH OTHERS IN THE QUOTIENT.
C
C       IRCHSZ  INTEGER OUTPUT SCALAR.
C               ELEMENT COUNT FOR VECTOR IRCHST.  IRCHSZ WILL BE <= N.
C
C       IRCHST  INTEGER OUTPUT VECTOR OF LENGTH IRCHSZ
C               THE VECTOR USED FOR THE REACHABLE SET.
C
C       NHDSZ   INTEGER OUTPUT SCALAR.
C               ELEMENT COUNT FOR VECTOR NBRHD.  NHDSZ WILL BE <= N.
C
C       NBRHD   INTEGER OUTPUT VECTOR OF LENGTH NHDSZ
C               THE SET OF ELIMINATED SUPERNODES ADJACENT TO SOME NODES
C               IN THE SET.
C
C  DESCRIPTION:
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC074 (IROOT, IADJ, JADJ, IDGREE, MARKER, IRCHSZ,
     &                   IRCHST, NHDSZE, NBRHD)
C
      INTEGER IROOT, IADJ(1), JADJ(1), IDGREE(1), MARKER(1), IRCHSZ,
     &        IRCHST(1), NHDSZE, NBRHD(1), I, ISTRT, ISTOP,
     &        J, JSTRT, JSTOP, NABOR, NODE
C
C-----------------------------------------------------------------------
C
C     -----------------------------------------
C     LOOP THROUGH THE NEIGHBORS OF IROOT IN THE
C     QUOTIENT GRAPH
C     -----------------------------------------
C
      NHDSZE = 0
      IRCHSZ = 0
      ISTRT  = IADJ(IROOT)
      ISTOP  = IADJ(IROOT+1) - 1
C
      IF ( ISTOP .LT. ISTRT ) GO TO 800
C
      DO 130 I = ISTRT, ISTOP
         NABOR = JADJ(I)
         IF ( NABOR .EQ. 0 ) GO TO 800
         IF ( MARKER(NABOR) .EQ. 0 ) THEN
            IF ( IDGREE(NABOR) .GE. 0 ) THEN
C
C              -------------------------------------
C              INCLUDE NABOR INTO THE REACHABLE SET.
C              -------------------------------------
C
               IRCHSZ         = IRCHSZ + 1
               IRCHST(IRCHSZ) = NABOR
               MARKER(NABOR)  = 1
               GO TO 130
            ENDIF
C
C           -------------------------------------
C           NABOR HAS BEEN ELIMINATED. FIND NODES
C           REACHABLE FROM IT.
C           -------------------------------------
C
            MARKER(NABOR) = -1
            NHDSZE        = NHDSZE + 1
            NBRHD(NHDSZE) = NABOR
C
  110       CONTINUE
            JSTRT = IADJ(NABOR)
            JSTOP = IADJ(NABOR + 1) - 1
            DO 120 J = JSTRT, JSTOP
               NODE  = JADJ(J)
               NABOR = -NODE
C
               IF      (NODE .GT. 0) THEN
                  IF ( MARKER(NODE) .EQ. 0 ) THEN
                     IRCHSZ         = IRCHSZ +1
                     IRCHST(IRCHSZ) = NODE
                     MARKER(NODE)   = 1
                  ENDIF
               ELSE IF (NODE .LT. 0) THEN
                  GO TO 110
               ELSE
                  GO TO 130
               ENDIF
  120       CONTINUE
         ENDIF
  130 CONTINUE
C
  800 CONTINUE
      RETURN
      END
