C***** QTC075  MINIMUM DEGREE QUOT. TRANSFORM  REV 1.0         JAN 88
C
C  PURPOSE:
C       PERFORMS THE QUOTIENT GRAPH TRANSFORMATION AFTER A NODE HAS
C       BEEN ELIMINATED.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          THOMAS COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC075 (IROOT, IADJ, JADJ, MARKER, IRCHSZ, IRCHST, NBRHD)
C
C  PARAMETERS:
C       IROOT   INTEGER INPUT SCALAR
C               THE NODE JUST ELIMINATED.  IT BECOMES THE REPRESENTATIVE
C               OF THE NEW SUPERNODE.
C
C       IADJ    INTEGER INPUT VECTOR OF LENGTH N+1
C               CONTAINS POINTERS INTO THE ADJACENCY VECTOR, JADJ.
C               IADJ(N+1) = 2*NE+1, WHERE NE IS THE NUMBER OF EDGES.
C
C       JADJ    INTEGER INPUT/OUTPUT VECTOR OF LENGTH 2*NE
C               ON INPUT, CONTAINS THE ADJACENCY STRUCTURE OF THE GRAPH.
C               ON OUTPUT, CONTAINS THE ADJACENCY OF THE QUOTIENT GRAPH.
C
C       MARKER  INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               THE MARKER VECTOR.
C
C       IRCHSZ  INTEGER OUTPUT SCALAR.
C               ELEMENT COUNT FOR VECTOR IRCHST.  IRCHSZ WILL BE <= N.
C
C       IRCHST  INTEGER OUTPUT VECTOR OF LENGTH IRCHSZ
C               THE REACHABLE SET OF IROOT IN THE OLD QUOTIENT GRAPH.
C
C       NBRHD   INTEGER OUTPUT VECTOR OF LENGTH NHDSZ <= N
C               THE NEIGHBORHOOD SET WHICH WILL BE MERGED WITH IROOT TO
C               FORM THE NEW SUPERNODE.
C
C  DESCRIPTION:
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC075 (IROOT, IADJ, JADJ, MARKER, IRCHSZ, IRCHST,
     &                   NBRHD)
C
      INTEGER IROOT, IADJ(1), JADJ(1), MARKER(1), IRCHSZ, IRCHST(1),
     &        NBRHD(1), INHD, IRCH, J, JSTRT, JSTOP, LINK, NABOR, NODE
C
C-----------------------------------------------------------------------
C
      IRCH = 0
      INHD = 0
      NODE = IROOT
C
C     ---------------------------------------------
C     PLACE REACH NODES INTO ADJACENT LIST OF NODES
C     ---------------------------------------------
C
  100 CONTINUE
      JSTRT = IADJ(NODE)
      JSTOP = IADJ(NODE+1) - 2
      IF ( JSTOP .GE. JSTRT ) THEN
         DO 110 J = JSTRT, JSTOP
            IRCH    = IRCH + 1
            JADJ(J) = IRCHST(IRCH)
            IF ( IRCH .GE. IRCHSZ ) GOTO 200
  110    CONTINUE
      ENDIF
C
C     ----------------------------------------------
C     LINK TO OTHER SPACE PROVIDED BY THE NBRHD SET.
C     ----------------------------------------------
C
      LINK = JADJ(JSTOP+1)
      NODE = -LINK
C
      IF ( LINK .GE. 0 ) THEN
         INHD = INHD + 1
         NODE = NBRHD(INHD)
         JADJ(JSTOP+1) = -NODE
      ENDIF
C
      GO TO 100
C
C     -------------------------------------------------------
C     ALL REACHABLE NODES HAVE BEEN SAVED.  END THE ADJ LIST.
C     ADD IROOT TO THE NBR LIST OF EACH NODE IN THE REACH SET.
C     -------------------------------------------------------
C
  200 CONTINUE
      JADJ(J+1) = 0
      DO 220 IRCH = 1, IRCHSZ
         NODE = IRCHST(IRCH)
         IF ( MARKER(NODE) .GE. 0 ) THEN
            JSTRT = IADJ(NODE)
            JSTOP = IADJ(NODE+1) - 1
            DO 210 J = JSTRT, JSTOP
               NABOR = JADJ(J)
               IF ( MARKER(NABOR) .LT. 0 ) THEN
                  JADJ(J) = IROOT
                  GOTO 220
               ENDIF
  210       CONTINUE
         ENDIF
  220 CONTINUE
C
      RETURN
      END
