C***** QTC077  BUILD SPARSE SYMM. STRUCTURE    REV 1.0         JAN 88
C
C  PURPOSE:
C       BUILDS THE DATA STRUCTURE FOR A REORDERED SPARSE SYMMETRIC
C       MATRIX.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC077 (N, IADJ, JADJ, IPERMR, IPERMF, ICP, IRN, MAXNS, NS,
C                    IWRK1, IWRK2, IWRK3, IWRK4, IERR)
C
C  PARAMETERS:
C       N       INTEGER INPUT SCALAR
C               NUMBER OF EQUATIONS.
C
C       IADJ    INTEGER INPUT VECTOR OF LENGTH N+1
C               POINTERS INTO THE ADJACENCY VECTOR.  IADJ(N+1) = 2*NE+1,
C               WHERE NE IS THE NUMBER OF EDGES.
C
C       JADJ    INTEGER INPUT VECTOR OF LENGTH 2*NE
C               THE ADJACENCY STRUCTURE OF THE GRAPH OF THE MATRIX.
C
C       IPERMR  INTEGER INPUT VECTOR OF LENGTH N
C               CONTAINS THE REVERSE PERMUTATION VECTOR.
C
C       IPERMF  INTEGER INPUT VECTOR OF LENGTH N
C               CONTAINS THE FORWARD PERMUTATION VECTOR.
C
C       ICP     INTEGER OUTPUT VECTOR OF LENGTH N+1
C               COLUMN POINTERS INTO THE ARRAY IRN.
C
C       IRN     INTEGER OUTPUT VECTOR OF LENGTH MAXNS
C               ROW NUMBERS ARRAY.
C
C       MAXNS   INTEGER INPUT SCALAR
C               NUMBERS OF WORDS AVAILABLE IN ARRAY IRN.
C
C       NS      INTEGER OUTPUT SCALAR
C               NUMBERS OF WORDS USED IN ARRAY IRN; I.E., THE NUMBER
C               OF SPARSE ELEMENTS (NON-ZERO AND FILLIN) IN THE FULL
C               LOWER TRIANGLE OF THE MATRIX.
C
C       IWRK1   INTEGER SCRATCH VECTOR OF LENGTH N+1
C
C       IWRK2   INTEGER SCRATCH VECTOR OF LENGTH N
C
C       IWRK3   INTEGER SCRATCH VECTOR OF LENGTH N
C
C       IWRK4   INTEGER SCRATCH VECTOR OF LENGTH N
C
C       IERR    INTEGER OUTPUT SCALAR
C               COMPLETION CODE: IERR = 0 - NORMAL COMPLETION
C                                IERR = 1 - INSUFFICIENT SPACE IN IRN
C
C  DESCRIPTION:
C       GIVEN A SPARSE SYMMETRIC MATRIX OF ORDER N WHOSE GRAPH IS
C       SPECIFIED BY THE ADJACENCY STRUCTURE (IADJ, JADJ) AND A
C       REORDERING OF THE MATRIX SPECIFIED BY THE PERMUTATION VECTORS
C       (IPERMR, IPERMF), THIS ROUTINE BUILDS THE MATH ADVANTAGE DATA
C       STRUCTURE (ICP, IRN) FOR THE REODERED MATRIX.  THE ROUTINE
C       QTC079 IS FIRST CALLED TO SYMBOLICALLY FACTOR THE MATRIX AND
C       BUILD THE COMPRESSED ROW NUMBER VECTOR.  THE COMPRESSED ROW
C       NUMBER VECTOR IS THEN EXPANDED IN-PLACE.
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       QTC079
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC077 (N, IADJ, JADJ, IPERMR, IPERMF, ICP, IRN,
     &                   MAXNS, NS, IWRK1, IWRK2, IWRK3, IWRK4, IERR)
C
      INTEGER N, IADJ(1), JADJ(1), IPERMR(1), IPERMF(1), ICP(1), IRN(1),
     &        MAXNS, NS, IWRK1(1), IWRK2(1), IWRK3(1), IWRK4(1), IERR
      INTEGER I, J, K, KSTRT, KSTOP
C
C-----------------------------------------------------------------------
C
C     ------------------------------
C     PERFORM SYMBOLIC FACTORIZATION
C     ------------------------------
C
      CALL QTC079 (N, IADJ, JADJ, IPERMR, IPERMF, ICP, IRN, MAXNS,
     &             IWRK1, IWRK2, IWRK3, IWRK4, IERR)
C
      IF (IERR .NE. 0) GO TO 810
C
      NS = IWRK1(N) + N - 1
      IF (NS .GT. MAXNS) GO TO 810
C
C     ------------------
C     EXPAND ICP AND IRN
C     ------------------
C
      J = NS + 1
      ICP(N+1) = J
C
      DO 120 I = N, 1, -1
         KSTRT = ICP(I) + IWRK1(I+1) - IWRK1(I) - 1
         KSTOP = ICP(I)
C
         IF (KSTRT .GE. KSTOP) THEN
            DO 110 K = KSTRT, KSTOP, -1
               J = J - 1
               IRN(J) = IRN(K)
  110       CONTINUE
         ENDIF
C
         J  = J - 1
         ICP(I) = J
         IRN(J) = I
  120 CONTINUE
C
      RETURN
C
C     ----------------------------------------------------
C     ERROR - INSUFFICIENT STORAGE FOR NONZERO SUBSCRIPTS.
C     ----------------------------------------------------
C
  810 CONTINUE
      IERR = 1
      RETURN
C
      END
