C***** QTC079  SPARSE SYMBOLIC FACTORIZATION   REV 1.0         JAN 88
C
C  PURPOSE:
C       PERFORMS A SYMBOLIC FACTORIZATION ON A PERMUTED LINEAR SYSTEM
C       AND SETS UP THE COMPRESSED DATA STRUCTURE FOR THE SYSTEM.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          THOMAS COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC079 (N, IADJ, JADJ, IPERMR, IPERMF, ICP, IRN, MAXNS,
C                    ILNZ, IRCLNK, MRGLNK, MARKER, IERR)
C
C  PARAMETERS:
C       N       INTEGER INPUT SCALAR
C               NUMBER OF EQUATIONS.
C
C       IADJ    INTEGER INPUT VECTOR OF LENGTH N+1
C               POINTERS INTO THE ADJACENCY VECTOR.  IADJ(N+1) = 2*NE+1,
C               WHERE NE IS THE NUMBER OF EDGES.
C
C       JADJ    INTEGER INPUT VECTOR OF LENGTH 2*NE
C               THE ADJACENCY STRUCTURE OF THE GRAPH OF THE MATRIX.
C
C       IPERMR  INTEGER INPUT VECTOR OF LENGTH N
C               CONTAINS THE REVERSE PERMUTATION VECTOR.
C
C       IPERMF  INTEGER INPUT VECTOR OF LENGTH N
C               CONTAINS THE FORWARD PERMUTATION VECTOR.
C
C       ICP     INTEGER OUTPUT VECTOR OF LENGTH N+1
C               COLUMN POINTERS INTO THE ARRAY IRN.
C
C       IRN     INTEGER OUTPUT VECTOR OF LENGTH MAXNS
C               ROW NUMBERS IN COMPRESSED FORMAT.
C
C       MAXNS   INTEGER INPUT SCALAR
C               NUMBERS OF WORDS AVAILABLE IN ARRAY IRN.
C
C       ILNZ    INTEGER OUTPUT VECTOR OF LENGTH N+1
C               COLUMN POINTERS INTO THE LOWER NON-ZERO STRUCTURE.
C
C       IRCLNK  INTEGER SCRATCH VECTOR OF LENGTH N
C
C       MRGLNK  INTEGER SCRATCH VECTOR OF LENGTH N
C
C       MARKER  INTEGER SCRATCH VECTOR OF LENGTH N
C
C       IERR    INTEGER OUTPUT SCALAR
C               COMPLETION CODE: IERR = 0 - NORMAL COMPLETION
C                                IERR = 1 - INSUFFICIENT SPACE IN IRN
C
C  DESCRIPTION:
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC079 (N, IADJ, JADJ, IPERMR, IPERMF, ICP, IRN,
     &                   MAXNS, ILNZ, IRCLNK, MRGLNK, MARKER, IERR)
C
      INTEGER N, IADJ(1), JADJ(1), IPERMR(1), IPERMF(1), ICP(1), IRN(1),
     &        MAXNS, ILNZ(1), IRCLNK(1), MRGLNK(1), MARKER(1), IERR
      INTEGER I, INZ, IRCHM, J, JSTOP, JSTRT, K, KNZ, KXSUB, LMAX, M,
     &        MRGK, MRKFLG, NABOR, NODE, NP1, NZBEG, NZEND
      LOGICAL TEST
C
C-----------------------------------------------------------------------
C
C     --------------
C     INITIALIZATION
C     --------------
C
      NZBEG   = 1
      NZEND   = 0
      ILNZ(1) = 1
C
      DO 110 K = 1, N
         MRGLNK(K) = 0
         MARKER(K) = 0
  110 CONTINUE
C
C     --------------------------------------------------
C     FOR EACH COLUMN, KNZ COUNTS THE NUMBER OF NONZEROS
C     IN COLUMN K ACCUMULATED IN IRCLNK.
C     --------------------------------------------------
C
      NP1 = N + 1
      DO 610 K = 1, N
         KNZ       = 0
         MRGK      = MRGLNK(K)
         MRKFLG    = 0
         MARKER(K) = K
         IF (MRGK .NE. 0) MARKER(K) = MARKER(MRGK)
C
         ICP(K) = NZEND
         NODE   = IPERMR(K)
         JSTRT  = IADJ(NODE)
         JSTOP  = IADJ(NODE+1) - 1
         IF (JSTRT .GT. JSTOP) GO TO 600
C
C        ----------------------------------------
C        USE IRCLNK TO LINK THROUGH THE STRUCTURE
C        A(*,K) BELOW DIAGONAL.
C        ----------------------------------------
C
         IRCLNK(K) = NP1
         DO 220 J = JSTRT, JSTOP
            NABOR = JADJ(J)
            NABOR = IPERMF(NABOR)
            IF (NABOR .GT. K) THEN
               IRCHM = K
C
  210          CONTINUE
                  M = IRCHM
                  IRCHM = IRCLNK(M)
                  IF (IRCHM .LE. NABOR) GO TO 210
C
               KNZ = KNZ + 1
               IRCLNK(M)     = NABOR
               IRCLNK(NABOR) = IRCHM
               IF (MARKER(NABOR) .NE. MARKER(K)) MRKFLG = 1
            ENDIF
  220    CONTINUE
C
C        -------------------------------------
C        TEST FOR MASS SYMBOLIC ELIMINATION---
C        -------------------------------------
C
         LMAX = 0
         TEST = MRKFLG .NE. 0 .OR. MRGK .EQ. 0 .OR. MRGLNK(MRGK) .NE. 0
         IF (.NOT.TEST) THEN
            ICP(K) = ICP(MRGK) + 1
            KNZ    = ILNZ(MRGK+1) - (ILNZ(MRGK) + 1)
            GO TO 500
         ENDIF
C
C        -----------------------------------------------
C        LINK THROUGH EACH COLUMN I THAT AFFECTS L(*,K).
C        -----------------------------------------------
C
         I = K
  310    CONTINUE
            I = MRGLNK(I)
            IF (I .EQ. 0) GO TO 400
C
            INZ   = ILNZ(I+1) - ILNZ(I) - 1
            JSTRT = ICP(I) + 1
            JSTOP = ICP(I) + INZ
            IF (INZ .GT. LMAX) THEN
               LMAX   = INZ
               ICP(K) = JSTRT
            ENDIF
C
C           -----------------------------------------------
C           MERGE STRUCTURE OF L(*,I) IN IRN INTO IRCLNK.
C           -----------------------------------------------
C
            IRCHM = K
            DO 330 J = JSTRT, JSTOP
               NABOR = IRN(J)
C
  320          CONTINUE
               M = IRCHM
               IRCHM = IRCLNK(M)
C
               IF      (IRCHM .LT. NABOR) THEN
                  GO TO 320
               ELSE IF (IRCHM .GT. NABOR) THEN
                  KNZ = KNZ+1
                  IRCLNK(M)     = NABOR
                  IRCLNK(NABOR) = IRCHM
                  IRCHM = NABOR
               ENDIF
  330       CONTINUE
            GO TO 310
C
C        ------------------------------------------------------
C        CHECK IF SUBSCRIPTS DUPLICATE THOSE OF ANOTHER COLUMN.
C        ------------------------------------------------------
C
  400    CONTINUE
         IF (KNZ .EQ. LMAX) GO TO 500
C
C        -----------------------------------------------
C        OR IF TAIL OF K-1ST COLUMN MATCHES HEAD OF KTH.
C        -----------------------------------------------
C
         IF (NZBEG .LE. NZEND) THEN
            I = IRCLNK(K)
            DO 420 JSTRT = NZBEG, NZEND
               IF      (IRN(JSTRT) .GT. I) THEN
                  GO TO 430
               ELSE IF (IRN(JSTRT) .EQ. I) THEN
                  ICP(K) = JSTRT
                  DO 410 J = JSTRT, NZEND
                     IF (IRN(J) .NE. I) GO TO 430
                     I = IRCLNK(I)
                     IF (I .GT. N) GO TO 500
  410             CONTINUE
                  NZEND = JSTRT - 1
                  GO TO 430
               ENDIF
  420       CONTINUE
         ENDIF
C
C        ----------------------------------------
C        COPY THE STRUCTURE OF L(*,K) FROM IRCLNK
C        TO THE DATA STRUCTURE (ICP, IRN).
C        ----------------------------------------
C
  430    CONTINUE
         NZBEG = NZEND + 1
         NZEND = NZEND + KNZ
         IF (NZEND .GT. MAXNS) GO TO 810
C
         I = K
         DO 440 J = NZBEG, NZEND
            I = IRCLNK(I)
            IRN(J)    = I
            MARKER(I) = K
  440    CONTINUE
C
         ICP(K)    = NZBEG
         MARKER(K) = K
C
C        -------------------------------------------------------
C        UPDATE THE VECTOR MRGLNK.  NOT COLUMN L(*,K) JUST FOUND
C        IS REQUIRED TO DETERMINE COLUMN L(*, J), WHERE
C        L(J,K) IS THE FIRST NONZERO IN L(*,K) BELOW DIAGONAL.
C        -------------------------------------------------------
C
  500    CONTINUE
         IF (KNZ .GT. 1) THEN
            KXSUB = ICP(K)
            I = IRN(KXSUB)
            MRGLNK(K) = MRGLNK(I)
            MRGLNK(I) = K
         ENDIF
C
  600    CONTINUE
         ILNZ(K+1) = ILNZ(K) + KNZ
  610 CONTINUE
C
      IERR = 0
      RETURN
C
C     ----------------------------------------------------
C     ERROR - INSUFFICIENT STORAGE FOR NONZERO SUBSCRIPTS.
C     ----------------------------------------------------
C
  810 CONTINUE
      IERR = 1
      RETURN
C
      END
