C*****  RFFT2D  Real-to-Complex 2-D FFT           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RFFT2D (C,NRC,NCC,IFLG)
C
C       where,
C
C       C       Real input/output matrix.
C
C       NRC     Integer input number of rows.
C
C       NCC     Integer input number of columns.
C
C       IFLG    Integer input processing option flag:
C                   = 1 for forward FFT
C                   =-1 for inverse FFT
C
C
C  DESCRIPTION
C
C       This routine performs either a real-to-complex two-
C       dimensional forward or complex-to-real two-dimensional
C       inverse FFT on the data stored in matrix C, depending
C       on the value of IFLG.  The result will be in a special
C       packed complex array form, occupying the same NRC by NCC
C       locations of C.
C
C       If IFLG = 1, the routine performs a real-to-complex forward
C       two-dimensional FFT.  The results are overlaid on matrix C.
C       These results are not properly scaled and may be scaled
C       using VSMUL to multiply by 1/(2*NRC*NCC).
C
C       If IFLG = -1, the routine performs a complex-to-real inverse
C       FFT.  The results are overlaid on matrix C and do not need
C       to be scaled.
C
C       Both NRC and NCC must be powers of two.
C
C       The array format on output of Forward FFT is:
C
C                           Columns
C               1     2     3     4     5     6        NCC-1  NCC
C              ----  ----  ----  ----  ----  ----       ----  ----
C       Row 1: real  real  real  imag  real  imag  ...  real  imag
C       Row 2: real  real  real  imag  real  imag  ...  real  imag
C
C       Row 3: real  real  real  real  real  real  ...  real  real
C       Row 4: imag  imag  imag  imag  imag  imag  ...  imag  imag
C
C       Row 5: real  real  real  real  real  real  ...  real  real
C       Row 6: imag  imag  imag  imag  imag  imag  ...  imag  imag
C               ..    ..    ..    ..    ..    ..   ...   ..    ..
C               ..    ..    ..    ..    ..    ..   ...   ..    ..
C               ..    ..    ..    ..    ..    ..   ...   ..    ..
C               ..    ..    ..    ..    ..    ..   ...   ..    ..
C       NRC-1: real  real  real  real  real  real  ...  real  real
C       NRC:   imag  imag  imag  imag  imag  imag  ...  imag  imag
C
C       Notice that the first two rows are different from the rest.
C       The first two rows each resemble outputs of a real FFT.  Refer
C       to RFFTSC for a description of the special packed complex
C       format. Note, though, that the second row contains what would
C       have been in the NRC+1 row, had there been room for an NRC+1
C       row.
C
C       Rows 3 through NRC resemble outputs of a complex FFT, in
C       pairs of rows.  For example, in rows 3 and 4, the first element
C       of row 3 is the first real of the complex FFT output and the
C       first element of row 4 is the first imaginary of the complex FFT
C       output.
C
C       Refer to Appendix B for machine dependent notes.
C
C
C  REFERENCE
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RFFT2D (C,16,16,1)
C
C       Input Operands:
C
C       C =    2.0  2.0 ... for 16 columns total 2.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C
C       Output Operands:
C
C       C =   64.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE RFFT2D(C,NRC,NCC,IFLG)
C
      REAL C(1),B
      INTEGER NRC,NCC,IFLG,I,IC
      IF (NRC.LE.0 .OR. NCC.LE.0 .OR.
     +  (IFLG.NE.-1 .AND. IFLG.NE.1)) GOTO 900
      B = 0.5
      IF (IFLG.EQ.-1) GOTO 500
C
C     DO FORWARD RFFT2D
C
C --- COLUMNS
      IC = 1
      DO 200 I = 1,NCC*NRC,NRC
        CALL QTC019(C(I),NRC,IC,IFLG)
200   CONTINUE
C
C --- ROWS
      IC = NRC
      CALL QTC019(C(1),NCC,IC,IFLG)
      CALL QTC019(C(2),NCC,IC,IFLG)
      CALL CVSMUL(C(1),IC,B,C(1),IC,NCC)
      DO 100 I = 3, NRC, 2
        CALL QTC018(C(I),NCC,IC,IFLG)
100   CONTINUE
      GOTO 900
C
C     DO INVERSE RFFT2D
C
C --- ROWS
500   IC = NRC
      CALL QTC019(C(1),NCC,IC,IFLG)
      CALL QTC019(C(2),NCC,IC,IFLG)
      DO 600 I = 3, NRC, 2
        CALL QTC018(C(I),NCC,IC,IFLG)
600   CONTINUE
C
C --- COLUMNS
      IC = 1
      DO 700 I = 1,NCC*NRC,NRC
        CALL QTC019(C(I),NRC,IC,IFLG)
700   CONTINUE
900   RETURN
      END
