C*****  RFFTF    Real-to-Complex Forward FFT     MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RFFTF (A,C,N)
C
C       where,
C
C       A       Real input/output vector.
C
C       C       Complex output vector.
C
C       N       Integer input real element count.
C
C
C  DESCRIPTION
C
C       This routine performs a real-to-complex forward
C       FFT on the data stored in vector A.  It performs the same
C       operation as RFFT with IFLG=1 but the results are stored in
C       another vector, C, rather than in the input vector A.
C       Array A will be modified.
C
C       The results are stored in vector C in a special packed
C       complex array format.  See RFFTSC for details on the packed
C       format.  These results are not properly scaled and may be
C       scaled using RFFTSC to multiply by 1/(2*N).
C
C       N must be a power of two.
C
C       Refer to Appendix B for machine dependent notes.
C
C  REFERENCE
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RFFTF (A,C,16)
C
C       Input Operands:
C
C       A = 1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C
C       Output Operands:
C
C       C = 32.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C
C
C  HISTORY
C         1) Feb 87     L. Shanbeck      Original.
C
C
      SUBROUTINE RFFTF(A,C,N)
C
      INTEGER N
      REAL A(1),C(1)
      IF (N.LE.1 ) GOTO 900
        CALL RFFT(A,N,1)
        CALL VMOV(A,1,C,1,N)
900   RETURN
      END
