C*****  RFFTSC  Real FFT Scale and Format         MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RFFTSC (C,N,IFLG,ISCL)
C
C       where,
C
C       C       Complex input/output vector.
C               On input, C contains the data from a
C               forward FFT or the data for an inverse FFT.
C               On output, C contains the formatted and
C               scaled data.
C
C       N       Integer input real element count.
C
C       IFLG    Integer input formatting flag:
C                   =  1,0,or -1 for no change in format of
C                      results.
C                   =  2 for RFFT results unpacked into N/2
C                      complex elements.
C                   =  3 for RFFT results unpacked into N/2+1
C                      complex elements.
C                   = -2 for N/2 complex elements packed into
C                      RFFT format.
C                   = -3 for N/2+1 complex elements packed into
C                      RFFT format.
C
C       ISCL    Integer input scaling flag:
C                   = 0 for no scaling of results.
C                   = 1 to multiply results by 1/(2*N).
C                   =-1 to multiply results by 1/(4*N).
C
C  DESCRIPTION
C
C       This routine scales the results of a real-to-complex
C       forward FFT and converts a complex vector between the
C       special packed RFFT format and the normal complex vector
C       format.
C
C       RFFTSC may be used after a forward real-to-complex FFT
C       or before an inverse complex-to-real FFT to scale results
C       and format the complex numbers.
C
C
C       The Packed Format
C
C       A forward FFT on an array of N real values outputs N/2 + 1
C       complex values.  Since only N locations are available in
C       array C, the complex data is stored in a special packed
C       format.  This packing takes advantage of the fact that the
C       first and last output elements of a forward FFT have zero-valued
C       imaginary parts.  It uses the first element's imaginary location
C       to store the last element's real value, eliminating the need for
C       the last complex location.
C
C       An example of the forward FFT output data format:
C
C       real(1)       (This is the first element's real value)
C       real(N/2+1)   (This is the last element's real value)
C       real(2)       (This is the format for the ordinary
C       imag(2)       complex values)
C        .
C        .
C        .
C       real(N/2)
C       imag(N/2)
C
C       After the first two reals, the rest of the array is stored
C       as ordinary complex numbers.
C
C
C       Formatting
C
C        VALUE            INPUT                 OUTPUT
C
C       IFLG = 2    C(1) = real C(1)       C(1) = real C(1)
C                   C(2) = real C(N/2+1)   C(2) = 0.0
C
C       IFLG = 3    C(1) = real C(1)       C(1) = real C(1)
C                   C(2) = real C(N/2+1)   C(2) = 0.0
C                    .                      .
C                    .                      .
C                    .                      .
C                   C(N+1) = (anything)    C(N+1) = real C(N/2+1)
C                   C(N+2) = (anything)    C(N+2) = 0.0
C
C       IFLG = -2   C(1) = real C(1)       C(1) = real C(1)
C                   C(2) = (anything)      C(2) = 0.0
C
C       IFLG = -3   C(1) = real C(1)       C(1) = real C(1)
C                   C(2) = (anything)      C(2) = real C(N/2+1)
C                    .                      .
C                    .                      .
C                    .                      .
C                   C(N+1) = real C(N/2+1) C(N+1) = (anything)
C                   C(N+2) = 0.0           C(N+2) = (anything)
C
C                               Note
C       In this diagram, the left side of the equal sign
C       uses subscripts that refer to the physical storage location
C       within C, while the right side of the equal sign uses
C       subscripts of the complex vector C.
C
C
C       Scaling
C
C       The results of a forward real-to-complex FFT must be multiplied
C       by 1/(2*N) for proper scaling (ISCL = 1).  The results of an
C       inverse complex-to-real FFT require no scaling.  The 1/(4*N)
C       scaling (ISCL = -1) is used in the FFT correlation routines.
C
C            C(i) =  W * C(i)     for i=1,N
C
C       where,
C
C            W = 1        if ISCL = 0
C
C            W = 1/(2*N)  if ISCL = 1
C
C            W = 1/(4*N)  if ISCL = -1
C
C
C  REFERENCE
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C   EXAMPLE
C
C       CALL RFFTSC (C,4,0,1)
C
C       Input Operands:
C
C       C = 8.000
C           0.000
C           0.000
C           0.000
C
C       Output Operands:
C
C       C = 1.000
C           0.000
C           0.000
C           0.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE RFFTSC(C,N,IFLG,ISCL)
C
      REAL C(1),WT
      INTEGER N,IFLG,ISCL,IA
      IF (N.LE.0 .OR. ISCL.LT.-1 .OR. ISCL.GT.1 .OR.
     +  IFLG.LT.-3 .OR. IFLG.GT.3) GOTO 100
      WT = 1.0
      IF (ISCL) 30,75,40
30      WT = 0.25 / FLOAT(N)
        GOTO 50
40      WT = 0.50 / FLOAT(N)
50    CONTINUE
      DO 70 IA=1,N
        C(IA) = WT * C(IA)
70    CONTINUE
75    IF (IABS(IFLG).LT.2) GOTO 95
        IF (IABS(IFLG).EQ.2) GOTO 80
          IF (IFLG.EQ.3) GOTO 77
            C(2) = WT * C(N+1)
            GOTO 95
C         ELSE IFLG=3:
77          C(N+1) = C(2)
            C(N+2) = 0.0
C         ENDIF
C       ENDIF
80      C(2) = 0.0
95    CONTINUE
C     ENDIF
100   RETURN
      END
