C*****  RFFTX   Real FFT with SIN/COS Table     MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1987-1988 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RFFTX (C,N,IDIR,INIT,RTAB,IERR)
C
C       where,
C
C       C       Real input/output vector.
C
C       N       Integer input real element count.
C
C       IDIR    Integer input direction flag:
C                  IDIR > 0  - Perform forward FFT.
C                  IDIR = 0  - No FFT performed.
C                  IDIR < 0  - Perform inverse FFT.
C
C       INIT    Integer input initialization flag:
C                  INIT <> 0 - Initialize RTAB table.
C                  INIT =  0 - No initialization.
C
C       RTAB    Real input/output vector of length N+1.
C                  Input when INIT = 0.
C                  Output when INIT <> 0.
C
C       IERR    Integer output completion code:
C                  IERR =  0  - Normal completion.
C                  IERR >  0  - Invalid value of N (see below).
C                  IERR = -2  - Invalid tables (see below).
C
C  DESCRIPTION
C
C       This routine performs either a real-to-complex forward
C       or complex-to-real inverse FFT on the data stored in
C       vector C, depending on the value of IDIR.
C
C       If IDIR > 0, the routine performs a forward FFT.  The results
C       are overlaid on vector C.  These results are not properly
C       scaled and may be scaled using RFFTSC to multiply by 1/N.
C
C       If IDIR < 0, the routine performs an inverse FFT.  The results
C       are overlaid on vector C and do not need to be scaled.
C
C       If INIT is nonzero, then a table corresponding to the specific
C       value of N is generated, stored, and returned in the vector RTAB.
C       If INIT = 0, RTAB is not generated, thus a table previously
C       generated must be supplied as an input in RTAB.  A sine/cosine
C       table generated by this routine may also be used as input
C       to the Math Advantage subroutine CFFTX.
C
C       When RTAB is generated, the value of N is stored in the
C       first element of the table.  In subsequent calls with INIT = 0,
C       the input value of N is checked against the first element of
C       RTAB.  If N is greater than the first element from RTAB then
C       the table is declared to be invalid.
C
C       If both IDIR and INIT are nonzero, then the table generation
C       occurs prior to performing the FFT.  If INIT is nonzero and
C       IDIR is zero, the table generation occurs but no FFT is performed.
C       If both IDIR and INIT are zero, the only action is the validity
C       checking of N and the input table RTAB.
C
C       N must be a power of two.  If the value of N is invalid, then
C       the value returned in IERR is the smallest valid length that
C       is greater than N; i.e., IERR is set to the smallest power of
C       two > N.
C
C       Refer to Appendix B for machine dependent notes.
C
C
C  REFERENCE
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RFFTX (C, 8, 1, 1, RTAB, IERR)
C
C       Input Operands:
C
C       C =   1.75
C            10.25
C             5.75
C             4.25
C             5.25
C             8.00
C             4.00
C             5.50
C
C       Output Operands:
C
C       C =  89.50000000
C           -22.50000000
C            -2.05025291
C            -4.91421318
C            -5.49999905
C           -17.00000000
C           -11.94974710
C             2.08578706
C
C       RTAB =  8.000000000
C               0.707106769
C               1.000000000
C               0.707106769
C               0.000000000
C              -0.707106769
C              -1.000000000
C              -0.707106769
C               0.000000000
C
C       IERR = 0
C
C  HISTORY
C         1) Feb 88     B. D. Leback    Original.
C
      SUBROUTINE RFFTX (C, N, IDIR, INIT, RTAB, IERR)
C
      REAL    C(1), RTAB(1)
      INTEGER N, IDIR, INIT, IERR, IC, NFFT, NT
C
C-----------------------------------------------------------------------
C
      IERR = 0
      IC   = 2
C
C  CHECK THAT N IS A POWER OF 2
C
      NFFT = 1
      DO 10 I = 1, 15
         NFFT = NFFT + NFFT
         IF (NFFT .GT. N) THEN
            IERR = NFFT
            GO TO 800
         ENDIF
         IF (NFFT .EQ. N) GO TO 20
   10 CONTINUE
C
C  CHECK VALIDITY OF TABLES
C
   20 CONTINUE
      IF (INIT .EQ. 0) THEN
         IF (N .GT. IFIX( RTAB(1) )) THEN
            IERR = -2
            GO TO 800
         ELSE
            NT = IFIX( RTAB(1) )
         ENDIF
      ELSE
         CALL QTC047 (RTAB(2), N)
         RTAB(1) = FLOAT(N)
         NT = N
      ENDIF
C
C  PERFORM FFT
C
      IF (IDIR .GT. 0) THEN
         CALL QTC046 (C(1), N/2, IC, IDIR, RTAB(2), NT)
         CALL QTC049 (C(1), N, IDIR, RTAB(2), NT)
      ELSE IF (IDIR .LT. 0) THEN
         CALL QTC049 (C(1), N, IDIR, RTAB(2), NT)
         CALL QTC046 (C(1), N/2, IC, IDIR, RTAB(2), NT)
      ENDIF
C
C  EXIT ROUTINE
C
  800 CONTINUE
      RETURN
      END
