C*****  RGEAA  Real General Matrix Eigenvalues & Eigenvectors MATHADV REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RGEAA(NM,N,A,W,Z,IWRK,WRK,IERR)
C
C       where,
C
C       NM      Integer input number of rows in full matrices A and Z.
C
C       N       Integer input order of matrices A and Z.
C
C       A       Real input matrix.
C
C       W       Complex output vector of length N, eigenvalues.
C
C       Z       Real output matrix, eigenvectors.
C
C       IWRK    Integer workspace vector of length N.
C
C       WRK     Real workspace vector of length N.
C
C       IERR    Integer output completion code:
C                If IERR=0, the routine terminated normally.
C                If 1<=IERR<=N, the calculation of eigenvalue IERR
C                 failed to converge.  Eigenvalues IERR+1 to N are still
C                 valid; none of the eigenvectors are valid.
C
C  DESCRIPTION
C
C       This routine determines all eigenvalues and all eigenvectors
C       of real matrix A.
C
C       The eigenvalues, stored in vector W, are unordered except that
C       complex conjugate pairs of eigenvalues appear consecutively
C       with the eigenvalue having the positive imaginary part first.
C
C       The eigenvectors, stored in matrix Z, may be real or complex. If
C       eigenvalue m is real, then column m of Z contains its real
C       eigenvector.  If eigenvalue m is complex with a positive
C       imaginary part, then columns m and m+1 of Z contain its complex
C       eigenvector.  The conjugate of this vector is the eigenvector
C       for the conjugate eigenvalue.
C
C       The eigenvectors are not normalized.
C
C       On output, matrix A is altered.
C
C       This routine contains a subset of the EISPACK eigensystem
C       package developed by Argonne National Laboratory.  It uses the
C       EISPACK recommended path of BALANC-ELMHES-ELTRAN-HQR2-BALBAK.
C
C
C  REFERENCE
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RGEAA(4,4,A,W,Z,IWRK,WRK,IERR)
C
C       Input Operands:
C
C       A =  3.0  2.0  0.0  0.0
C            1.0  1.0  4.0  0.0
C            2.0  3.0  1.0  2.0
C            5.0 -1.0  1.0  1.0
C
C       Output Operands:
C
C       W = ( 6.078, 0.000)
C           ( 1.559, 2.002)
C           ( 1.559,-2.002)
C           (-3.196, 0.000)
C
C       Z =  0.587   0.011   0.414   0.323
C            0.903  -0.422  -0.287  -1.000
C            1.000   0.082  -0.355   0.968
C            0.597   1.000   0.000  -0.854
C
C       IERR = 0
C
C       Note concerning output values:
C
C       The eigenvalues (array W) may be arranged in any order; and the
C       rows of the eigenvectors (matrix Z) are associated with a particular
C       eigenvalue and will be ordered correspondingly.  Also, the eigen-
C       vectors may be multiplied by a constant and still be correct
C       (i.e., orthonormal vectors).
C
C  HISTORY
C         1) Sep 86     L. Tarvestad    Original.
C
C
      SUBROUTINE RGEAA(NM,N,A,W,Z,IWRK,WRK,IERR)
      INTEGER N,NM,IS1,IS2,IERR
      REAL A(1),W(1),Z(1),WRK(1)
      INTEGER IWRK(1)
C
      IF (N.LE.0 .OR. N.GT.NM) GO TO 50
      CALL  QTC028(NM,N,A,IS1,IS2,WRK)
      CALL  QTC036(NM,N,IS1,IS2,A,IWRK)
      CALL  QTC037(NM,N,IS1,IS2,A,IWRK,Z)
      CALL  QTC038(NM,N,IS1,IS2,A,W,Z,IERR)
      IF (IERR .NE. 0) GO TO 50
      CALL  QTC029(NM,N,IS1,IS2,WRK,N,Z)
50    RETURN
      END
