C*****  RMESFC  Real Envelope Factor              MATH ADVANTAGE REL 2.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMESFC (S,ICP,N,NS,ZTOL,IERR)
C
C       where,
C
C       S       Real input/output vector of length NS.
C               On input, S contains the elements of the real
C               matrix A stored in envelope symmetric format.
C               On output, S contains a superposition of the L' and D
C               factors of A.
C
C       ICP     Integer input vector of column pointers of length N+1.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a diagonal
C                      element was less than or equal to ZTOL.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine factors a real symmetric matrix A,
C       represented in envelope format by the vectors S and ICP,
C       into LDL' form.
C
C       D is a diagonal matrix.  L is lower triangular, and has all 1's
C       on its diagonal.  L' is the transpose of L.  L' and the
C       reciprocated elements of D are overlaid on S.  L is not stored.
C
C       This routine does not do pivoting.  Therefore, the
C       matrix A should be numerically stable in the form in which
C       it is input.
C
C
C  REFERENCE
C
C       C. R. Rao.  1962.  A note on a generalized inverse of a
C       matrix with application to problems in mathematical
C       statistics.  J. R. Statis. Soc., Vol. B24,  pp. 152-
C       158.
C
C       M. J. R. Healy.  1968.  Triangular decomposition of a
C       symmetric matrix.  Appl. Statis., Vol. 17,  pp. 195-
C       197.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RMESFC (S,ICP,5,12,ZTOL,IERR)
C
C       Input Operands:
C
C       S =  8.00          ICP = 1
C           10.00                2
C            8.00                3
C            1.00                5
C            7.00                8
C            0.00               13
C            1.00
C            6.00
C            0.00
C            0.00
C            0.00
C            2.00
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       S = 0.125
C           0.100
C           0.127
C           0.100
C           0.145
C          -0.013
C           0.100
C           0.182
C           0.000
C           0.000
C           0.000
C           0.250
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE RMESFC(S,ICP,N,NS,ZTOL,IERR)
C
      INTEGER N,NS,ICP(1),IERR
      REAL    S(1),SUM,TEMP,ZTOL
      INTEGER I,IC,J,J1,J2,K,K1,K2,KJ,KP,MAX,NJ,NP,P
C
      IF (N.LE.0 .OR. NS.LE.0) GOTO 700
C
      MAX = 0
      DO 110 J = 1, N
         NJ = ICP(J+1) - ICP(J)
         IF (NJ .GT. MAX) MAX = NJ
  110 CONTINUE
C
      DO 150 P = 1, N
         KP = ICP(P)
         K1 = ICP(P  ) + 1
         K2 = ICP(P+1) - 1
         IF (K1 .LE. K2) GOTO 115
            TEMP = S(KP)
            IF (ABS(TEMP) .LE. ZTOL) GO TO 800
            S(KP) = 1.0 / TEMP
            GO TO 150
115      CONTINUE
C
         SUM = 0.0
         I = P
         DO 120 K = K1, K2
            I = I - 1
            TEMP = S(K) * S(ICP(I))
            SUM = SUM + TEMP * S(K)
            S(K) = TEMP
  120    CONTINUE
C
         TEMP = S(KP) - SUM
         IF (ABS(TEMP) .LE. ZTOL) GO TO 800
         S(KP) = 1.0 / TEMP
C
         NP = K2 - K1 + 1
         J1 = P + 1
         J2 = P + MIN0( MAX-1, N-P)
         IF (J1 .GT. J2) GO TO 150
C
         DO 140 J = J1, J2
            KJ = ICP(J  ) + J - P
            NJ = ICP(J+1) - 1 - KJ
            IF (NJ .LE. 0) GO TO 140
            K2 = KP + MIN0( NP, NJ)
            IC = KJ - KP
            SUM = 0.0
            DO 130 K = K1, K2
               SUM = SUM + S(K) * S(K+IC)
  130       CONTINUE
            S(KP+IC) = S(KP+IC) - SUM
  140    CONTINUE
  150 CONTINUE
C
700   IERR = 0
      GOTO 900
C
  800 CONTINUE
      IERR = P
900   RETURN
      END
