C*****  RMESFS  Real Envelope Factor and Solve      MATH ADVANTAGE REL 2.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMESFS (S,ICP,N,NS,ZTOL,BX,M,IERR)
C
C       where,
C
C       S       Real input/output vector of length NS.
C               On input, S contains the elements of the real
C               matrix A stored in envelope symmetric format.
C               On output, S contains a superposition of the L' and D
C               factors of A.
C
C       ICP     Integer input vector of column pointers of length N+1.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       BX      Real input/output matrix of dimension N by M.
C               On input, BX contains M right-hand sides.
C               On output, BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a diagonal
C                      element was less than or equal to ZTOL.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine solves the real linear system Ax = b where A
C       is represented in envelope format by the vectors S
C       and ICP.  This routine calls RMESFC to perform an LDL'
C       factorization of A and then calls RMESSV to solve
C       the system.
C
C
C  REFERENCE
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RMESFS (S,ICP,5,12,ZTOL,BX,2,IERR)
C
C       Input Operands:
C
C       S =  8.00          ICP = 1
C           10.00                2
C            8.00                3
C            1.00                5
C            7.00                8
C            0.00               13
C            1.00
C            6.00
C            0.00
C            0.00
C            0.00
C            2.00
C
C       BX = 8.0      -70.0
C          -45.0      -62.0
C           11.0       65.0
C           16.0      -14.0
C           24.0      -34.0
C
C       ZTOL = 1.0E-5
C
C
C       Output Operands:
C
C       S = 0.125
C           0.100
C           0.127
C           0.100
C           0.145
C          -0.013
C           0.100
C           0.182
C           0.000
C           0.000
C           0.000
C           0.250
C
C       BX = 0.0    -8.0
C           -5.0    -7.0
C            2.0     9.0
C            3.0    -1.0
C            4.0    -3.0
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE RMESFS(S,ICP,N,NS,ZTOL,BX,M,IERR)
C
      INTEGER M,N,NS,ICP(1),IERR
      REAL    S(1),BX(1),ZTOL
C
      IERR = 0
      IF (M.LE.0 .OR. N.LE.0 .OR. NS.LE.0) GOTO 900
      CALL RMESFC(S,ICP,N,NS,ZTOL,IERR)
      IF (IERR .EQ. 0) CALL RMESSV(S,ICP,N,NS,BX,M)
C
900   RETURN
      END
