C*****  RMFUIN  Real Full Matrix Invert           MATH ADVANTAGE REL 2.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMFUIN (A,NRA,N,ZTOL,IPERM,X,NRX,IERR)
C
C       where,
C
C       A       Real input/output matrix.  On input, A contains
C               the matrix to be inverted.  On output, A contains
C               the LU factored form.
C
C       NRA     Integer input number of rows in full matrix A.
C
C       N       Integer input order of submatrix A.
C
C       ZTOL    Real input scalar, pivot zero tolerance.
C
C       IPERM   Integer output permutation vector of length N.
C
C       X       Real output matrix containing the inverted matrix.
C
C       NRX     Integer input number of rows in full matrix X.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a pivot
C                      was less than or equal to ZTOL.
C                      This implies the matrix is singular.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine factors and inverts the real full
C       matrix A. It calls RMFUFC to factor A into LU form.
C       The factored matrix is stored in A and the inverted
C       matrix is stored in X.
C
C
C  REFERENCE
C
C       C. R. Rao.  1962.  A note on a generalized inverse of a
C       matrix with application to problems in mathematical
C       statistics.  J. R. Statis. Soc., Vol. B24,  pp. 152-
C       158.
C
C       M. J. R. Healy.  1968.  Triangular decomposition of a
C       symmetric matrix.  Appl. Statis., Vol. 17,  pp. 195-
C       197.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RMFUIN (A,5,5,ZTOL,IPERM,X,5,IERR)
C
C       Input Operands:
C
C       A = 0.000  -1.00  -5.000  11.00   8.000
C           8.000  16.00  -8.000  24.00   8.000
C          -4.000  -5.00   2.000  -4.00  -3.000
C          -3.000 -10.00   3.000 -13.00   5.000
C           2.000   6.00   6.000  -8.00  -2.000
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       A     = 0.125  2.000 -1.000  3.000  1.000
C              -3.000 -0.250  0.000  1.000 -2.000
C               2.000  2.000  0.125 -2.000  0.000
C               0.000 -1.000 -5.000  0.500  3.000
C              -4.000  3.000 -2.000  1.000  0.250
C
C       X     = 1.500 -1.426 -2.000 -1.094  0.563
C              -1.125  1.013  1.250  0.773 -0.391
C               1.750 -1.389 -1.500 -1.141  0.844
C               0.875 -0.690 -0.750 -0.602  0.359
C              -0.125  0.208  0.250  0.211 -0.016
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE RMFUIN(A,NRA,N,ZTOL,IPERM,X,NRX,IERR)
C
      INTEGER NRA,N,I,IERR,IPERM(1),J,K,NRX,IA,IX
      REAL    A(1),X(1),ZTOL
C
C  ********************************************************************
C
      IERR = 0
      IF (N.LE.0 .OR. NRA.LT.N .OR. NRX.LT.N) GO TO 800
C
C     FACTOR MATRIX
C
      CALL RMFUFC(A,NRA,N,ZTOL,IPERM,IERR)
      IF (IERR .NE. 0) GO TO 800
C
C     INITIALIZE INVERSE
C
      IX = 1
      DO 110 J = 1, N
         CALL VCLR( X(IX), 1, N)
         IX = IX + NRX
  110 CONTINUE
      CALL VMOV( A, NRA+1, X, NRX+1, N)
      IF (N .EQ. 1) GO TO 800
C
C     PERFORM FORWARD ELIMINATION
C
      IA = 2 + NRA
      DO 120 I = 2, N
         CALL QTC017(A(IA), X(I), NRX, A(I), NRA, X, NRX, I-1)
         IA = IA + 1 + NRA
  120 CONTINUE
C
C     PERFORM BACKWARD SUBSTITUTION
C
      IA = (N-1) * (NRA+1)
      DO 130 I = N-1, 1, -1
         CALL RNDOTP(A(IA),NRA,0,X(I+1),1,NRX,X(I),NRX,N-I,N,3)
         IA = IA - 1 - NRA
  130 CONTINUE
C
C     UNSCRAMBLE THE COLUMNS OF THE INVERSE
C
      IX = 1
      DO 150 J = 1, N-1
  140    CONTINUE
         K = IPERM(J)
         IF (K .EQ. J) GOTO 145
            IPERM(J) = IPERM(K)
            IPERM(K) = K
            CALL VSWAP( X(IX), 1, X(1+(K-1)*NRX), 1, N)
            GO TO 140
145      CONTINUE
         IX = IX + NRX
  150 CONTINUE
C
  800 CONTINUE
      RETURN
      END
