C*****  RMSSFC  Real Symmetric Sparse Factor      MATH ADVANTAGE REL 2.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMSSFC (S,IRN,ICP,N,NS,ZTOL,IERR)
C
C       where,
C
C       S       Real input/output vector of length NS.
C               On input, S contains the elements of the
C               real matrix A stored in sparse symmetric
C               format.  On output, S contains a superposition
C               of the L and D factors.
C
C       IRN     Integer input vector of length NS containing
C               the row number of each element stored in vector S.
C
C       ICP     Integer input vector of column pointers of length
C               N+1.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a diagonal
C                      element was less than or equal to ZTOL.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine factors a real sparse symmetric matrix A
C       represented by S, IRN and ICP into LDL' form.
C
C       D is a diagonal matrix.  L is a lower triangular matrix,
C       and has all 1's on its diagonal.  L' is the transpose of L.
C       L and the reciprocated elements of D are overlaid on S.
C       L' is not stored.
C
C       This routine does not do pivoting.  Therefore, the matrix A
C       should be numerically stable in the form in which it is input.
C
C
C  REFERENCE
C
C       C. R. Rao.  1962.  A note on a generalized inverse of a
C       matrix with application to problems in mathematical
C       statistics.  J. R. Statis. Soc., Vol. B24,  pp. 152-
C       158.
C
C       M. J. R. Healy.  1968.  Triangular decomposition of a
C       symmetric matrix.  Appl. Statis., Vol. 17,  pp. 195-
C       197.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RMSSFC (S,IRN,ICP,10,22,ZTOL,IERR)
C
C       Input Operands:
C
C       S =   4.0      IRN =   1   ICP =  1
C            13.0              2          2
C            24.0             10          4
C             5.0              3          6
C            -4.0              4         11
C            32.0              4         15
C            -2.0              5         18
C             2.0              6         20
C             3.0              7         21
C            10.0              8         22
C             4.0              5         23
C             0.0 (Fill-in)    6
C             0.0 (Fill-in)    7
C             0.0 (Fill-in)    8
C             4.0              6
C             0.0 (Fill-in)    7
C             0.0 (Fill-in)    8
C             4.0              7
C             0.0 (Fill-in)    8
C           100.0              8
C             4.0              9
C            64.0             10
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       S = 0.250
C           0.077
C           1.846
C           0.200
C          -0.800
C           0.035
C          -0.069
C           0.069
C           0.104
C           0.347
C           0.259
C           0.036 (Fill-in)
C           0.054 (Fill-in)
C           0.180 (Fill-in)
C           0.259
C          -0.056 (Fill-in)
C          -0.187 (Fill-in)
C           0.273
C          -0.305 (Fill-in)
C           0.010
C           0.250
C           0.051
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Aug 85     D. Cooper       ECR 8/6/85--fixed potential
C                                       infinite loop at statement 20.
C         3) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE RMSSFC(S,IRN,ICP,N,NS,ZTOL,IERR)
C
      INTEGER N,NS,IERR,L2,J,L1,L0,L,I,K
      REAL S(1),ZTOL
      REAL TMP,R
      INTEGER ICP(1),IRN(1)
      IF(N.LE.0 .OR. NS.LE.0) GO TO 90
      L2 = 1
      DO 60 J = 1, N
         L1 = L2
         L2 = ICP(J+1)
         TMP = S(L1)
         IF(ABS(TMP) .LE. ZTOL) GO TO 91
         TMP = 1.0 / TMP
         S(L1) = TMP
         IF(J .EQ. N) GO TO 60
         L1 = L1 + 1
         IF(L1 .GE. L2) GO TO 60
         DO 40 L0 = L1, L2-1
            IF(S(L0) .EQ. 0.0) GO TO 40
            R = TMP * S(L0)
            K = ICP(IRN(L0)) - 1
            DO 30 L = L0, L2-1
               I = IRN(L)
 20            CONTINUE
               K = K + 1
               IF(K .GT. NS) GOTO 90
               IF(IRN(K) .NE. I) GO TO 20
               S(K) = S(K) - R * S(L)
 30         CONTINUE
 40      CONTINUE
 60   CONTINUE
C
      IF (N.LT.2) GOTO 90
      L2 = ICP(1)
      DO 80 J = 1, N-1
         L1 = L2
         L2 = ICP(J+1)
         TMP = S(L1)
         L1 = L1 + 1
         IF(L1 .GE. L2) GO TO 80
         DO 70 L = L1, L2-1
            S(L) = TMP * S(L)
 70      CONTINUE
 80   CONTINUE
C
90    IERR = 0
      GOTO 900
C
91    IERR = J
C
900   RETURN
      END
