C*****  RMSSFL  Real Matrix Symmetric Define Fill-in     MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMSSFL (S,IRN,ICP,N,NS,M,VWK,LWK,T,JRN,JCP,NT,IERR)
C
C       where,
C
C       S       Real input vector of length NS.
C               Contains the elements of the real matrix A
C               stored in sparse symmetric format.
C
C       IRN     Integer input vector of length NS containing
C               the row number of each element stored in vector S.
C
C       ICP     Integer input vector of column pointers of length N+1.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       M       Integer input maximum length of T and JRN.
C
C       VWK     Real workspace vector of length N.
C
C       LWK     Integer workspace vector of length N.
C
C       T       Real output vector of length NT.
C               Contains updated S with space for fill-in
C               provided in the appropriate positions.
C
C       JRN     Integer output vector of length NT containing
C               the row number of each element stored in vector T.
C
C       JCP     Integer output vector of column pointers of length N+1.
C
C       NT      Integer output element count of vector T.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   =1 if the routine aborted because the
C                      specified value for M was too small to
C                      accommodate all fill-in values.
C
C
C  DESCRIPTION
C
C       This routine builds the sparse symmetric format vectors
C       T, JRN, and JCP (with space reserved for fill-in) describing
C       matrix A.  The non-zero elements of matrix A are input
C       by vector S, IRN, and ICP.  The output vectors are in a
C       form usable by RMSSFC and RMSSFS.  Output vectors must not
C       overlay input vectors.
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RMSSFL(S,IRN,ICP,10,16,22,VWK,LWK,T,JRN,JCP,NT,IERR)
C
C       Input Operands:
C
C       S =   4.0      IRN =   1   ICP =  1
C            13.0              2          2
C            24.0             10          4
C             5.0              3          6
C            -4.0              4         11
C            32.0              4         12
C            -2.0              5         13
C             2.0              6         14
C             3.0              7         15
C            10.0              8         16
C             4.0              5         17
C             4.0              6
C             4.0              7
C           100.0              8
C             4.0              9
C            64.0             10
C
C       Output Operands:
C
C       T =   4.0      JRN =   1   JCP =  1       NT =  22
C            13.0              2          2
C            24.0             10          4
C             5.0              3          6
C            -4.0              4         11
C            32.0              4         15
C            -2.0              5         18
C             2.0              6         20
C             3.0              7         21
C            10.0              8         22
C             4.0              5         23
C             0.0 (Fill-in)    6
C             0.0 (Fill-in)    7
C             0.0 (Fill-in)    8
C             4.0              6
C             0.0 (Fill-in)    7
C             0.0 (Fill-in)    8
C             4.0              7
C             0.0 (Fill-in)    8
C           100.0              8
C             4.0              9
C            64.0             10
C
C       IERR = 0
C
C  HISTORY
C         1) May 85     D. Cooper       Original.
C                       R. Coleman
C
      SUBROUTINE RMSSFL(S,IRN,ICP,N,NS,M,VWK,LWK,T,JRN,JCP,NT,IERR)
C
      REAL    S(1), T(1), VWK(1)
      INTEGER IRN(1),ICP(1),JRN(1),JCP(1),N,NS,M,NT,IERR
      INTEGER LWK(1),FALSE,TRUE
      INTEGER I,J,K,K1,K2,L
      DATA    FALSE, TRUE /0,1/
C
      IERR = 0
      IF (N.LE.0 .OR. NS.LE.0 .OR. M.LT.NS) GOTO 9000
C
C ... INITIALIZE WORKSPACES ***
C
      DO 110 I = 1, N
         VWK(I) = 0.0
         LWK(I) = FALSE
110   CONTINUE
C
C ... DO FIRST COLUMN ***
C
      NT = 0
      IF (IRN(1).EQ.1) GOTO 115
        T(1) = 0.0
        JRN(1) = 1
        NT = 1
115   CONTINUE
      JCP(1) = 1
      K1 = ICP(1)
      K2 = ICP(2)-1
      IF (K1.GT.K2) GOTO 125
        IF ((K2-K1+NT).LT.M) GOTO 117
          IERR = 1
          GOTO 9000
117     CONTINUE
        DO 120 K = K1,K2
          NT = NT + 1
          T(NT) = S(K)
          JRN(NT) = IRN(K)
120     CONTINUE
125   CONTINUE
C
C ... START MAIN LOOP ***
C
      IF (N.LT.3) GOTO 900
      DO 180 J = 2, N-1
        JCP(J) = NT+1
C
C ... EXPAND J-TH COLUMN ***
C
        LWK(J) = TRUE
        K1 = ICP(J)
        K2 = ICP(J+1)-1
        IF (K1.GT.K2) GOTO 131
          DO 130 K = K1, K2
            I = IRN(K)
            VWK(I) = S(K)
            LWK(I) = TRUE
130       CONTINUE
131     CONTINUE
C
C ... DO FILL-IN ***
C
        DO 150 L = 1, J-1
          K1 = JCP(L)+1
          K2 = JCP(L+1)-2
          IF (K1.GT.K2) GOTO 150
          DO 137 K = K1, K2
            I = JRN(K)
            IF (I.EQ.J) GOTO 140
            IF (I.GT.J) GOTO 150
137       CONTINUE
140       K1 = K+1
          K2 = K2+1
          DO 145 K = K1, K2
            LWK(JRN(K)) = TRUE
145       CONTINUE
150     CONTINUE
C
C ... COMPRESS COLUMN J INTO T ***
C
        DO 170 I = J, N
          IF (LWK(I) .EQ. FALSE) GOTO 170
          NT = NT+1
          IF (NT.LE.M) GOTO 160
            IERR = 1
            GOTO 9000
160       CONTINUE
          T(NT) = VWK(I)
          JRN(NT) = I
          VWK(I) = 0.0
          LWK(I) = FALSE
170     CONTINUE
180   CONTINUE
C
C ... DO LAST COLUMN ***
C
900   NT = NT+1
      IF (NT.LE.M) GOTO 925
        IERR = 1
        GOTO 9000
925   CONTINUE
      T(NT) = 0.0
      IF (ICP(N).LT.ICP(N+1)) T(NT) = S(ICP(N))
      JCP(N) = NT
      JCP(N+1) = NT+1
      JRN(NT) = N
C
9000  RETURN
      END
