C*****  RMSUSV  Real Sparse Solver                MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMSUSV (S,IRN,ICP,IDP,N,NS,BX,M)
C
C       where,
C
C       S       Real input vector of length NS.
C               S contains a superposition of the
C               L and U factors of A.
C
C       IRN     Integer input vector of length NS containing the
C               row number of each element stored in S.
C
C       ICP     Integer input vector of column pointers of length N+1.
C
C       IDP     Integer input vector of diagonal pointers of length N.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       BX      Real input/output matrix of dimension N by M.
C               On input, BX contains M right-hand sides. On output,
C               BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C
C  DESCRIPTION
C
C       This routine solves a real linear system Ax = b, where A
C       has been factored into LU form by RMSUFC and is represented
C       in sparse unsymmetric format by S, IRN, ICP, and IDP.
C
C
C  REFERENCE
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RMSUSV(S,IRN,ICP,IDP,10,18,BX,2)
C
C       Input Operands:
C
C       S = 0.500      IRN =  1  ICP =  1  IDP =  1
C           0.063             2         2         2
C           2.000             5         6         6
C           3.000             6         8         8
C           3.000            10        10        10
C           0.500             3        11        11
C          -1.000             4        12        13
C           0.250             4        15        15
C           4.000             8        16        16
C           0.500             5        17        18
C           0.167             6        19
C           0.500             4
C           0.250             7
C          -2.000             8
C           0.100             8
C           0.500             9
C           0.100             8
C           0.125            10
C
C       BX= 0.00    8.00
C         -80.00  -48.00
C           4.00   12.00
C          -4.00   10.00
C          -2.00   -6.00
C         -63.00  -15.00
C         -28.00    0.00
C          99.00   44.00
C          -2.00   14.00
C         -39.00   55.00
C
C      Output Operands:
C
C       BX=0.000   4.000
C         -5.000  -3.000
C          2.000   6.000
C          3.000   4.000
C          4.000   0.000
C         -8.000  -1.000
C         -7.000   0.000
C          9.000   2.000
C         -1.000   7.000
C         -3.000   8.000
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C
      SUBROUTINE RMSUSV(S,IRN,ICP,IDP,N,NS,BX,M)
C
      INTEGER M,N,NS,J,K,K1,K2
      REAL BX(1), S(1), TMP
      INTEGER ICP(1), IRN(1), IDP(1), II, L, LM1
C
      IF (N.LE.0  .OR. M.LE.0 .OR. NS.LE.0) GOTO 900
      DO 850 L = 1,M*N,N
        LM1 = L - 1
        IF (N.EQ.1) GOTO 21
        DO 20 J = 1, N-1
          K1 = IDP(J) + 1
          K2 = ICP(J+1) - 1
          II = J + LM1
          IF(BX(II) .EQ. 0.0) GO TO 20
          TMP = S(K1-1) * BX(II)
          BX(II) = TMP
          IF(K1 .GT. K2) GO TO 20
          DO 10 K = K1, K2
            BX(LM1+IRN(K)) = BX(LM1+IRN(K)) - TMP * S(K)
 10       CONTINUE
 20     CONTINUE
21      BX(LM1+N) = S(NS) * BX(LM1+N)
C
        IF (N.EQ.1) GOTO 850
        DO 40 J = N, 2, -1
          K1 = ICP(J)
          K2 = IDP(J) - 1
          IF(K1 .GT. K2) GO TO 40
          TMP = BX(J+LM1)
          IF (TMP .EQ. 0.0) GO TO 40
          DO 30 K = K1, K2
            BX(LM1+IRN(K)) = BX(LM1+IRN(K)) - TMP * S(K)
 30       CONTINUE
 40     CONTINUE
850   CONTINUE
900   RETURN
      END
