C*****  RMTUFS  Real Matrix Tridiagonal Unsym Factor & Solve MATHADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMTUFS (AD, AU, AL, N, ZTOL, BX, M, IERR)
C
C       where,
C
C       AD      Real input/output vector of length N.
C               On input, AD contains the main diagonal of the
C               tridiagonal matrix to be factored.
C               On output, AD contains the reciprocals of the
C               main diagonal of the factored matrix.
C
C       AU      Real input/output vector of length N-1.
C               On input, AU contains the upper diagonal of the
C               tridiagonal matrix to be factored.
C               On output, AU contains the reciprocals of the
C               upper diagonal of the factored matrix.
C
C       AL      Real input/output vector of length N-1.
C               On input, AL contains the lower diagonal of the
C               tridiagonal matrix to be factored.
C               On output, AL contains the reciprocals of the
C               lower diagonal of the factored matrix.
C
C       N       Integer input number of rows in full matrix.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       BX      Real input/output matrix of length M*N.
C               On input, BX contains M right-hand sides.
C               On output, BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a diagonal
C                      element was less than or equal to ZTOL.
C                      This implies the matrix is singular.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine solves a real linear system Ax = b, by calling
C       RMTUFC to factor the real tridiagonal matrix A, represented
C       in tridiagonal format by AD, AU and AL into LU form.
C       It then calls RMTUSV to solve the system.
C
C
C  REFERENCE
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RMTUFS (AD, AU, AL, 5, ZTOL, BX, 2, IERR)
C
C       Input Operands:
C
C       AD = -16.000   AU =  8.000   AL =  4.000
C             11.000         4.000        -2.000
C             -8.000        -4.000         5.000
C             17.000         4.000         0.000
C              5.000
C
C       ZTOL = 1.0E-5
C
C       BX =  64.000   -80.000
C           -134.000    92.000
C            -44.000   -32.000
C            205.000   -67.000
C             25.000   -30.000
C
C       Output Operands:
C
C       AD = -0.0625   AU = -0.5000   AL =  4.000
C             0.0769         0.3077        -2.000
C            -0.1354         0.5417         5.000
C             0.0700         0.2799         0.000
C             0.2000
C
C       BX =  -9.000     7.000
C            -10.000     4.000
C              3.000     5.000
C             10.000    -4.000
C              5.000    -6.000
C
C       IERR = 0
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C                       R. Coleman
C
      SUBROUTINE RMTUFS (AD, AU, AL, N, ZTOL, BX, M, IERR)
C
      REAL    AD(1), AU(1), AL(1), ZTOL, BX(1)
      INTEGER N, M, IERR
C
      IERR = 0
      IF (N .LE. 0 .OR. M .LE. 0) GO TO 900
      CALL RMTUFC (AD, AU, AL, N, ZTOL, IERR)
      IF (IERR .EQ. 0) CALL RMTUSV (AD, AU, AL, N, BX, M)
C
900   RETURN
      END
