C*****  RNCONV    Nested Convolution/Correlation       MTHADV EXT. REL 1.0
C
C
C  CALL FORMAT
C
C       CALL RNCONV (A,IAI,IAO,B,IB,C,ICI,ICO,N,K,M,L)
C
C       where,
C
C       A       Real input vector containing sub-vectors of length
C               1+(N-1)*L
C
C       IAI     Integer input inner loop stride for sub-vector of A.
C
C       IAO     Integer input outer loop stride between sub-vectors of A
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C                 IB >0 Perform correlation
C                 IB <0 Perform convolution
C
C       C       Real output vector.
C
C       ICI     Integer input inner loop stride for sub-vector of C.
C
C       ICO     Integer input outer loop stride between sub-vectors of C.
C
C       N       Integer input element count for sub-vector of C.
C
C       K       Integer input number of sub-vectors in C.
C
C       M       Integer input element count for B.
C
C       L       Integer input decimation factor.
C
C
C  DESCRIPTION
C
C       This routine is a nested version of the convolution/correlation
C       routine. The input vector A and output vector B contain multiple
C       sub-vectors. A convolution or correlation is perfomed over a
C       sub-vector of A using the operator B and placed in the output
C       sub-vector C for a set of K sub-vectors.
C
C       Depending on the sign of IB, this routine performs either
C       a convolution or correlation on two sub-vectors A and B and
C       stores the results in C.  Vector C may overlay vector
C       A but not vector B.
C
C       To perform a convolution, use a negative IB increment.
C       Since the stride for B is negative, B must point to the
C       last element in the vector.
C
C       A decimation factor L is specified.  If L=1, then the
C       convolution or correlation value for every position of A
C       and B is computed.  A value of L=3 indicates that only every
C       third possible output value is actually computed.
C
C       The formula for correlation of a single sub-vector with all
C       increments of 1 has the form:
C
C            C(i) = SUM{A(L*(i-1)+j) * B(j)}        for j=1,M and i=1,N
C
C       The formula for convolution of a single sub-vector with all
C       increments of 1 has the form:
C
C            C(i) = SUM{A(L*(i-1)+j) * B(M-j+1)}  for j=1,M and i=1,N
C
C       An increment other than 1 for the elements in the sub-vectors
C       A, B and C can be given by IAI, IB and ICI respectively. The
C       increment between sub-vectors of A and C is given by IAO and
C       ICO respectively. The number of sub-vectors calculated as out
C       to C is given by K. It should be noted that M-1 trailing elements
C       beyond each sub-vector of A are used in the calculation of each
C       sub-vector C.
C
C
C  EXAMPLE
C
C       For Correlation:
C
C       CALL CONV (A,1,10,B,1,C,1,6,6,2,5,1)
C
C       Input Operands:
C
C       A = 0.000
C           0.000
C           0.000
C           1.000
C           1.000
C           1.000
C           3.000
C           0.000
C           0.000
C           0.000
C           0.000
C           0.000
C           0.000
C           3.000
C           3.000
C           3.000
C           1.000
C           0.000
C           0.000
C           0.000
C
C       B = 0.000
C           1.000
C           2.000
C           0.000
C           0.000
C
C       Output Operands:
C
C       C = 0.000
C           2.000
C           3.000
C           3.000
C           7.000
C           3.000
C           0.000
C           6.000
C           9.000
C           9.000
C           5.000
C           1.000
C
C
C       For Convolution:
C
C       CALL CONV (A,1,10,B(5),-1,C,1,6,6,2,5,1)
C
C       Input Operands:
C
C       A = 0.000
C           0.000
C           0.000
C           1.000
C           1.000
C           1.000
C           3.000
C           0.000
C           0.000
C           0.000
C           0.000
C           0.000
C           0.000
C           3.000
C           3.000
C           3.000
C           1.000
C           0.000
C           0.000
C           0.000
C
C       B = 0.000
C           1.000
C           2.000
C           0.000
C           0.000
C
C       Output Operands:
C
C       C = 1.000
C           3.000
C           3.000
C           5.000
C           6.000
C           0.000
C           3.000
C           9.000
C           9.000
C           7.000
C           2.000
C           0.000
C
C
C  HISTORY
C         1) Nov 87     P. Crose       Original.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE RNCONV(A,IAI,IAO,B,IB,C,ICI,ICO,N,K,M,L)
C
      INTEGER IAI,IAO,IB,ICI,ICO,N,K,M,L
      REAL A(1),B(1),C(1)
      INTEGER KK, IKA, IKC
C
C-----------------------------------------------------------------------
C
      IF (M.LE.0 .OR. N.LE.0 .OR. K.LE.0 .OR. L.LE.0) GO TO 800
C
      DO 100 KK = 1, K
        IKA = 1 + (KK-1)*IAO
        IKC = 1 + (KK-1)*ICO
 
        CALL RNDOTP(A(IKA),IAI,L*IAI,B,IB,0,C(IKC),ICI,M,N,0)
100   CONTINUE
800   RETURN
      END
