C*****  SCOPY    Real Vector Copy                    MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL SCOPY (N,SX,INCX,SY,INCY)
C
C       where,
C
C       N       Integer input element count.
C
C       SX      Real input vector.
C
C       INCX    Integer input stride for vector SX.
C
C       SY      Real output vector.
C
C       INCY    Integer input stride for vector SY.
C
C
C  DESCRIPTION
C
C       This routine copies the elements of a real vector SX
C       into the elements of another real vector SY.
C
C       SY(i) = SX(i)                for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       CALL SCOPY (2,SX,1,SY,1)
C
C       Input Operands:
C
C       SX =  1.000
C             3.000
C
C       Output Operands:
C
C       SY =  1.000
C             3.000
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      SUBROUTINE SCOPY(N,SX,INCX,SY,INCY)
C
      REAL SX(1),SY(1)
      INTEGER N,INCX,INCY,II,KK,M
C
      IF (N.LE.0) GO TO 40
      II = 1
      KK = 1
      IF (INCX.LT.0) II = (1-N)*INCX + 1
      IF (INCY.LT.0) KK = (1-N)*INCY + 1
      DO 10 M=1,N
        SY(KK) = SX(II)
        II = II+INCX
        KK = KK+INCY
10    CONTINUE
40    RETURN
      END
