C*****  SDOT    Dot Product of Single Precision Reals      MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       SW = SDOT (N,SX,INCX,SY,INCY)
C
C       where,
C
C       N       Integer input element count.
C
C       SX      Real input vector.
C
C       INCX    Integer input stride for vector SX.
C
C       SY      Real input vector.
C
C       INCY    Integer input stride for vector SY.
C
C
C  DESCRIPTION
C
C       This function returns the dot product of the elements of vector SX
C       with the elements of vector SY.
C
C               SDOT = sum (SX(i)*SY(i))      for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       SW = SDOT (5,SX,1,SY,1)
C
C       Input Operands:
C
C       SX =  1.000
C             2.000
C             3.000
C             4.000
C             5.000
C
C       SY = -2.000
C            -1.000
C             0.000
C             1.000
C             2.000
C
C       Output Result:
C
C       SW = 10.0
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      REAL FUNCTION SDOT(N,SX,INCX,SY,INCY)
C
      REAL SX(1),SY(1)
      INTEGER N,INCX,INCY,II,KK,M
C
      SDOT = 0.0
      IF (N.LE.0) GO TO 40
      II = 1
      KK = 1
      IF (INCX.LT.0) II = (1-N)*INCX + 1
      IF (INCY.LT.0) KK = (1-N)*INCY + 1
      DO 10 M=1,N
        SDOT = SDOT + SX(II)*SY(KK)
        II = II + INCX
        KK = KK + INCY
10    CONTINUE
40    RETURN
      END
