C*****  SSCAL  Real Scalar Times a Real Vector        MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL SSCAL (N,SA,SX,INCX)
C
C       where,
C
C       N       Integer input element count.
C
C       SA      Real input scalar.
C
C       SX      Real input vector.
C
C       INCX    Integer input stride for vector SX.
C               May not be negative.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of a real vector SX
C       by a real scalar SA.
C
C       SX(i) = SA * SX(i)               for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       CALL SSCAL (2,SA,SX,1)
C
C       Input Operands:
C
C       SA =  2.000
C
C       SX =  1.000
C            -3.000
C
C       Output Operands:
C
C       SX =  2.000
C            -6.000
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      SUBROUTINE SSCAL(N,SA,SX,INCX)
C
      REAL SA,SX(1)
      INTEGER N,INCX,NS,M
C
      IF (N.LE.0 .OR. INCX.LT.0) GO TO 40
      NS = N*INCX
      DO 10 M=1,NS,INCX
        SX(M) = SA*SX(M)
10    CONTINUE
40    RETURN
      END
