C*****  SSMEAN  Sum of Squares (from the mean)   MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL SSMEAN (A,IA,C,D,N)
C
C       where,
C
C       A     Real input vector of length N.
C
C       IA    Integer input stride for vector A.
C
C       C     Real output scalar representing the mean of the
C             distribution contained in vector A.
C
C       D     Real output scalar representing the sum of the
C             squares from the mean.
C
C       N     Integer input element count for vector A.
C
C
C  DESCRIPTION
C
C       This routine calculates the sum of the squares from the mean,
C       from the distribution in vector A. The routine outputs
C       variables C and D which are calculated as follows:
C        C=SUM(A(i))/N where SUM(A(i)) is the sum of A(1)+A(2)+...+A(N).
C        D=SUM((A(i)-C)**2).
C
C
C  REFERENCES
C
C       John E. Freund. 1973. Modern Elementary Statistics, Fourth
C       Edition. New Jersey: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL SSMEAN(A,1,C,D,10)
C
C       Input Operands:
C
C       A = 1.0
C           2.0
C           3.0
C           4.0
C           5.0
C           6.0
C           7.0
C           8.0
C           9.0
C           10.0
C
C       Output Operands:
C
C       C = 5.5
C
C       D = 82.5
C
C
C  HISTORY
C         1) Feb 88     C. Ward           Original.
C
      SUBROUTINE SSMEAN(A,IA,C,D,N)
C
      INTEGER IA,N,I,II
      REAL A(1),C,D
C
      IF (N .LE. 0) GOTO 999
C
      D=0.0
C
      CALL MEANV(A,IA,C,N)
C
      II=1
C
      DO 12 I=1,N
         D=D+(A(II)-C)**2
         II=II+IA
 12   CONTINUE
C
 999  CONTINUE
      RETURN
      END
